/*
 * Decompiled with CFR 0.152.
 */
package com.qwerjk.pixelperfecttest;

import android.content.Context;
import android.graphics.Typeface;
import android.widget.Toast;
import com.qwerjk.andengine.entity.sprite.PixelPerfectAnimatedSprite;
import com.qwerjk.andengine.entity.sprite.PixelPerfectSprite;
import com.qwerjk.andengine.opengl.texture.region.PixelPerfectTextureRegion;
import com.qwerjk.andengine.opengl.texture.region.PixelPerfectTextureRegionFactory;
import com.qwerjk.andengine.opengl.texture.region.PixelPerfectTiledTextureRegion;
import com.qwerjk.pixelperfecttest.Logger;
import org.anddev.andengine.engine.Engine;
import org.anddev.andengine.engine.camera.Camera;
import org.anddev.andengine.engine.handler.IUpdateHandler;
import org.anddev.andengine.engine.options.EngineOptions;
import org.anddev.andengine.engine.options.resolutionpolicy.IResolutionPolicy;
import org.anddev.andengine.engine.options.resolutionpolicy.RatioResolutionPolicy;
import org.anddev.andengine.entity.IEntity;
import org.anddev.andengine.entity.scene.Scene;
import org.anddev.andengine.entity.scene.background.ColorBackground;
import org.anddev.andengine.entity.scene.background.IBackground;
import org.anddev.andengine.entity.shape.IShape;
import org.anddev.andengine.entity.shape.Shape;
import org.anddev.andengine.entity.text.ChangeableText;
import org.anddev.andengine.entity.util.FPSLogger;
import org.anddev.andengine.extension.input.touch.controller.MultiTouch;
import org.anddev.andengine.extension.input.touch.controller.MultiTouchController;
import org.anddev.andengine.extension.input.touch.exception.MultiTouchException;
import org.anddev.andengine.input.touch.TouchEvent;
import org.anddev.andengine.input.touch.controller.ITouchController;
import org.anddev.andengine.opengl.font.Font;
import org.anddev.andengine.opengl.texture.ITexture;
import org.anddev.andengine.opengl.texture.TextureOptions;
import org.anddev.andengine.opengl.texture.atlas.bitmap.BitmapTextureAtlas;
import org.anddev.andengine.opengl.texture.atlas.bitmap.BitmapTextureAtlasTextureRegionFactory;
import org.anddev.andengine.ui.activity.BaseGameActivity;

public class PixelPerfectTest
extends BaseGameActivity {
    private static final int CAMERA_WIDTH = 480;
    private static final int CAMERA_HEIGHT = 320;
    private Camera mCamera;
    private BitmapTextureAtlas triangleTexture;
    private BitmapTextureAtlas diamondTexture;
    private PixelPerfectTiledTextureRegion triangleRegion;
    private PixelPerfectTextureRegion diamond100Region;
    private PixelPerfectTextureRegion diamond32Region;
    private BitmapTextureAtlas mFontTexture;
    private Font mFont;
    private PixelPerfectTextureRegion starRegion;

    public Engine onLoadEngine() {
        this.mCamera = new Camera(0.0f, 0.0f, 480.0f, 320.0f);
        Engine engine = new Engine(new EngineOptions(true, EngineOptions.ScreenOrientation.LANDSCAPE, (IResolutionPolicy)new RatioResolutionPolicy(480.0f, 320.0f), this.mCamera));
        try {
            if (MultiTouch.isSupported((Context)this)) {
                engine.setTouchController((ITouchController)new MultiTouchController());
            } else {
                Toast.makeText((Context)this, (CharSequence)"Sorry your device does NOT support MultiTouch!\n\n(Falling back to SingleTouch.)\n\nControls are placed at different vertical locations.", (int)1).show();
            }
        }
        catch (MultiTouchException e) {
            Toast.makeText((Context)this, (CharSequence)"Sorry your Android Version does NOT support MultiTouch!\n\n(Falling back to SingleTouch.)\n\nControls are placed at different vertical locations.", (int)1).show();
        }
        return engine;
    }

    public void onLoadResources() {
        PixelPerfectTextureRegionFactory.setAssetBasePath("gfx/");
        BitmapTextureAtlasTextureRegionFactory.setAssetBasePath((String)"gfx/");
        this.mFontTexture = new BitmapTextureAtlas(256, 256, TextureOptions.BILINEAR_PREMULTIPLYALPHA);
        this.mFont = new Font(this.mFontTexture, Typeface.create((Typeface)Typeface.DEFAULT, (int)1), 48.0f, true, -16777216);
        this.mEngine.getTextureManager().loadTexture((ITexture)this.mFontTexture);
        this.mEngine.getFontManager().loadFont(this.mFont);
        this.triangleTexture = new BitmapTextureAtlas(2048, 128, TextureOptions.BILINEAR_PREMULTIPLYALPHA);
        this.diamondTexture = new BitmapTextureAtlas(1024, 256, TextureOptions.BILINEAR_PREMULTIPLYALPHA);
        this.triangleRegion = PixelPerfectTextureRegionFactory.createTiledFromAsset(this.triangleTexture, (Context)this, "spinning-triangle.png", 0, 0, 20, 1);
        this.diamond100Region = PixelPerfectTextureRegionFactory.createFromAsset(this.diamondTexture, (Context)this, "diamond-100.png", 0, 0);
        this.diamond32Region = PixelPerfectTextureRegionFactory.createFromAsset(this.diamondTexture, (Context)this, "diamond-32.png", 102, 0);
        this.starRegion = PixelPerfectTextureRegionFactory.createFromAsset(this.diamondTexture, (Context)this, "star.png", 200, 0);
        this.mEngine.getTextureManager().loadTextures(new ITexture[]{this.triangleTexture, this.diamondTexture});
    }

    public Scene onLoadScene() {
        this.mEngine.registerUpdateHandler((IUpdateHandler)new FPSLogger());
        Scene scene = new Scene(1);
        scene.setBackground((IBackground)new ColorBackground(0.09804f, 0.6274f, 0.8784f));
        PixelPerfectSprite diamond100 = this.addSprite(scene, 400, 100, this.diamond100Region);
        PixelPerfectSprite diamond32 = this.addSprite(scene, 300, 100, this.diamond32Region);
        PixelPerfectSprite star = this.addSprite(scene, 0, 50, this.starRegion);
        PixelPerfectAnimatedSprite spinningTriangle = this.addAnimatedSprite(scene, 130, 150, 200, this.triangleRegion);
        spinningTriangle.setCurrentTileIndex(9);
        final Shape[] sprites = new Shape[]{diamond100, diamond32, spinningTriangle, star};
        long t0 = System.currentTimeMillis();
        for (int i = 0; i < 1000; ++i) {
            spinningTriangle.collidesWith((IShape)star);
        }
        Logger.f("1000 collisions in %d ms", System.currentTimeMillis() - t0);
        final ChangeableText collisionText = new ChangeableText(0.0f, 0.0f, this.mFont, "no collisions");
        scene.attachChild((IEntity)collisionText);
        scene.registerUpdateHandler(new IUpdateHandler(){

            public void reset() {
            }

            public void onUpdate(float pSecondsElapsed) {
                for (Shape spriteA : sprites) {
                    for (Shape spriteB : sprites) {
                        if (spriteA == spriteB || !spriteA.collidesWith((IShape)spriteB)) continue;
                        collisionText.setText("bam!");
                        return;
                    }
                }
                collisionText.setText("");
            }
        });
        return scene;
    }

    private PixelPerfectAnimatedSprite addAnimatedSprite(Scene scene, int x, int y, int speed, PixelPerfectTiledTextureRegion region) {
        PixelPerfectAnimatedSprite sprite = new PixelPerfectAnimatedSprite(x, y, region){
            boolean mGrabbed;
            {
                this.mGrabbed = false;
            }

            public boolean onAreaTouched(TouchEvent pSceneTouchEvent, float pTouchAreaLocalX, float pTouchAreaLocalY) {
                switch (pSceneTouchEvent.getAction()) {
                    case 0: {
                        this.mGrabbed = true;
                        break;
                    }
                    case 2: {
                        if (!this.mGrabbed) break;
                        this.setPosition(pSceneTouchEvent.getX() - this.getWidth() / 2.0f, pSceneTouchEvent.getY() - this.getHeight() / 2.0f);
                        break;
                    }
                    case 1: {
                        if (!this.mGrabbed) break;
                        this.mGrabbed = false;
                    }
                }
                return true;
            }
        };
        sprite.animate(speed, true);
        scene.attachChild((IEntity)sprite);
        scene.registerTouchArea((Scene.ITouchArea)sprite);
        return sprite;
    }

    private PixelPerfectSprite addSprite(Scene scene, int x, int y, PixelPerfectTextureRegion region) {
        PixelPerfectSprite sprite = new PixelPerfectSprite(x, y, region){
            boolean mGrabbed;
            {
                this.mGrabbed = false;
            }

            public boolean onAreaTouched(TouchEvent pSceneTouchEvent, float pTouchAreaLocalX, float pTouchAreaLocalY) {
                switch (pSceneTouchEvent.getAction()) {
                    case 0: {
                        this.mGrabbed = true;
                        break;
                    }
                    case 2: {
                        if (!this.mGrabbed) break;
                        this.setPosition(pSceneTouchEvent.getX() - this.getWidth() / 2.0f, pSceneTouchEvent.getY() - this.getHeight() / 2.0f);
                        break;
                    }
                    case 1: {
                        if (!this.mGrabbed) break;
                        this.mGrabbed = false;
                    }
                }
                return true;
            }
        };
        scene.attachChild((IEntity)sprite);
        scene.registerTouchArea((Scene.ITouchArea)sprite);
        return sprite;
    }

    public void onLoadComplete() {
    }
}

