/*
 * Decompiled with CFR 0.152.
 */
package com.qwerjk.andengine.collision;

import android.graphics.Bitmap;
import android.util.Log;

public class PixelPerfectBitMask {
    private static final int INT_WIDTH = 32;
    private int[][] mask;
    private int width;
    private int height;
    private int columns;

    public PixelPerfectBitMask(Bitmap bmp, int width, int height) {
        this(bmp, 0, 0, width, height);
    }

    public PixelPerfectBitMask(Bitmap bmp, int xOffset, int yOffset, int width, int height) {
        this.height = height;
        this.width = width;
        this.columns = (width + 31) / 32;
        int stride = this.columns * 32;
        this.mask = new int[height][this.columns];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int[] nArray = this.mask[y];
                int n = x / 32;
                nArray[n] = nArray[n] | (bmp.getPixel(x + xOffset, y + yOffset) == 0 ? 0 : 1) << 32 - x % 32 - 1;
            }
        }
    }

    public boolean collidesWith(PixelPerfectBitMask oMask, int xOffset, int yOffset) {
        PixelPerfectBitMask ppBitMaskB;
        PixelPerfectBitMask ppBitMaskA;
        if (xOffset >= 0) {
            ppBitMaskA = this;
            ppBitMaskB = oMask;
        } else {
            xOffset = -xOffset;
            yOffset = -yOffset;
            ppBitMaskA = oMask;
            ppBitMaskB = this;
        }
        int[][] maskB = ppBitMaskB.getMask();
        int heightB = ppBitMaskB.getHeight();
        int widthB = ppBitMaskB.getWidth();
        int colsB = (widthB + 31) / 32;
        int[][] maskA = ppBitMaskA.getMask();
        int widthA = ppBitMaskA.getWidth();
        int heightA = ppBitMaskA.getHeight();
        int colsA = (widthA + 31) / 32;
        int xColumnOffset = xOffset / 32;
        int xBitOffset = xOffset % 32;
        int xLBitOffset = (32 - xBitOffset) % 32;
        int yMin = Math.max(0, yOffset);
        int yMax = Math.min(heightA, heightB + yOffset);
        int xColMin = Math.max(0, xColumnOffset);
        int xColMax = Math.min(colsA, colsB + xColumnOffset);
        for (int rowA = yMin; rowA < yMax; ++rowA) {
            for (int colA = xColMin; colA < xColMax; ++colA) {
                int composite;
                int colB = colA - xColumnOffset;
                int rowB = rowA - yOffset;
                int n = composite = colB > 0 ? maskB[rowB][colB - 1] << xLBitOffset | maskB[rowB][colB] >>> xBitOffset : maskB[rowB][colB] >>> xBitOffset;
                if ((composite & maskA[rowA][colA]) == 0) continue;
                return true;
            }
        }
        return false;
    }

    public void printMask() {
        for (int row = 0; row < this.height; ++row) {
            String rowString = "";
            for (int col = 0; col < this.columns; ++col) {
                rowString = rowString + String.format("%32s", Integer.toBinaryString(this.mask[row][col]));
            }
            rowString = rowString.replaceAll("0", ".");
            rowString = rowString.replaceAll("1", "#");
            Log.v((String)"mask", (String)rowString);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int[][] getMask() {
        return this.mask;
    }
}

