/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.interceptor;

import com.vaadin.external.org.slf4j.Logger;
import com.vaadin.external.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.atmosphere.client.TrackMessageSizeFilter;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.ApplicationConfig;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventListenerAdapter;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.BroadcastFilter;
import org.atmosphere.cpr.FrameworkConfig;

public class JavaScriptProtocol
implements AtmosphereInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(JavaScriptProtocol.class);
    private String wsDelimiter = "|";
    private final TrackMessageSizeFilter f = new TrackMessageSizeFilter();

    @Override
    public void configure(AtmosphereConfig config) {
        String s = config.getInitParameter(ApplicationConfig.MESSAGE_DELIMITER);
        if (s != null) {
            this.wsDelimiter = s;
        }
    }

    @Override
    public Action inspect(final AtmosphereResource r) {
        String uuid = r.getRequest().getHeader("X-Atmosphere-tracking-id");
        String handshakeUUID = r.getRequest().getHeader("X-atmo-protocol");
        if (uuid != null && uuid.equals("0") && handshakeUUID != null) {
            r.getRequest().header("X-atmo-protocol", null);
            StringBuffer message = new StringBuffer(r.uuid()).append(this.wsDelimiter).append(System.currentTimeMillis());
            boolean track = false;
            if (r.getBroadcaster().getBroadcasterConfig().hasFilters()) {
                for (BroadcastFilter bf : r.getBroadcaster().getBroadcasterConfig().filters()) {
                    if (!TrackMessageSizeFilter.class.isAssignableFrom(bf.getClass())) continue;
                    track = true;
                    break;
                }
            }
            ((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r)).cors();
            final AtomicReference<String> protocolMessage = new AtomicReference<String>(message.toString());
            if (track) {
                protocolMessage.set((String)this.f.filter(r, protocolMessage.get(), protocolMessage.get()).message());
            }
            if (r.transport() != AtmosphereResource.TRANSPORT.LONG_POLLING && r.transport() != AtmosphereResource.TRANSPORT.JSONP) {
                AtmosphereResourceEventListenerAdapter a = new AtmosphereResourceEventListenerAdapter(){

                    @Override
                    public void onSuspend(AtmosphereResourceEvent event) {
                        r.getResponse().write((String)protocolMessage.get());
                        try {
                            r.getResponse().flushBuffer();
                        }
                        catch (IOException e) {
                            logger.trace("", (Throwable)e);
                        }
                    }
                };
                r.getRequest().setAttribute(FrameworkConfig.CALLBACK_JAVASCRIPT_PROTOCOL, a);
                r.addEventListener(a);
            } else {
                r.getResponse().write(protocolMessage.get());
            }
            if (r.transport() == AtmosphereResource.TRANSPORT.WEBSOCKET || r.transport() == AtmosphereResource.TRANSPORT.STREAMING || r.transport() == AtmosphereResource.TRANSPORT.SSE) {
                return Action.CONTINUE;
            }
            return Action.SKIP_ATMOSPHEREHANDLER;
        }
        return Action.CONTINUE;
    }

    @Override
    public void postInspect(AtmosphereResource r) {
    }

    public String toString() {
        return "Atmosphere JavaScript Protocol";
    }
}

