/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.labs.smartsprites;

import com.google.common.io.Closeables;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.carrot2.labs.smartsprites.SpriteImageDirective;
import org.carrot2.labs.smartsprites.SpriteImageOccurrence;
import org.carrot2.labs.smartsprites.SpriteReferenceOccurrence;
import org.carrot2.labs.smartsprites.SpriteReferenceReplacement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpriteImage {
    public final BufferedImage sprite;
    public final Map<SpriteReferenceOccurrence, SpriteReferenceReplacement> spriteReferenceReplacements;
    public final SpriteImageOccurrence spriteImageOccurrence;
    public boolean hasReducedForIe6 = false;
    public String resolvedPath;
    public String resolvedPathIe6;
    public int spriteWidth;
    public int spriteHeight;
    public float scaleRatio;
    private static final Pattern SPRITE_VARIABLE = Pattern.compile("${sprite}", 16);

    public SpriteImage(BufferedImage sprite, SpriteImageOccurrence spriteImageOccurrence, Map<SpriteReferenceOccurrence, SpriteReferenceReplacement> spriteReplacements, int width, int height, float scale) {
        this.sprite = sprite;
        this.spriteReferenceReplacements = spriteReplacements;
        this.spriteImageOccurrence = spriteImageOccurrence;
        this.spriteWidth = width;
        this.spriteHeight = height;
        this.scaleRatio = scale;
        for (SpriteReferenceReplacement replacement : spriteReplacements.values()) {
            replacement.spriteImage = this;
        }
    }

    String resolveImagePath(byte[] image, String timestamp, boolean reducedForIe6) {
        Matcher md5Matcher;
        String imagePath = this.spriteImageOccurrence.spriteImageDirective.imagePath;
        if (this.spriteImageOccurrence.spriteImageDirective.uidType != SpriteImageDirective.SpriteUidType.NONE && !SpriteImageDirective.SpriteUidType.MD5.pattern.matcher(imagePath).find() && !SpriteImageDirective.SpriteUidType.DATE.pattern.matcher(imagePath).find()) {
            imagePath = imagePath + "?${" + this.spriteImageOccurrence.spriteImageDirective.uidType.toString() + "}";
        }
        if ((md5Matcher = SpriteImageDirective.SpriteUidType.MD5.pattern.matcher(imagePath)).find()) {
            imagePath = md5Matcher.replaceAll(SpriteImage.computeMd5(image));
        }
        imagePath = SpriteImageDirective.SpriteUidType.DATE.pattern.matcher(imagePath).replaceAll(timestamp);
        imagePath = SPRITE_VARIABLE.matcher(imagePath).replaceAll(this.spriteImageOccurrence.spriteImageDirective.spriteId);
        if (reducedForIe6) {
            this.resolvedPathIe6 = SpriteImage.addIe6Suffix(imagePath, reducedForIe6);
            return this.resolvedPathIe6;
        }
        this.resolvedPath = SpriteImage.addIe6Suffix(imagePath, reducedForIe6);
        return this.resolvedPath;
    }

    static String addIe6Suffix(String spritePath, boolean ie6Reduced) {
        if (ie6Reduced) {
            int lastDotIndex;
            StringBuilder ie6Path = new StringBuilder();
            int lastFoundIndex = 0;
            int lastSlashIndex = spritePath.lastIndexOf("/");
            if (lastSlashIndex >= 0) {
                ie6Path.append(spritePath, lastFoundIndex, lastSlashIndex + 1);
                lastFoundIndex = lastSlashIndex + 1;
            }
            if ((lastDotIndex = spritePath.lastIndexOf(".")) < lastFoundIndex) {
                lastDotIndex = -1;
            }
            int firstQuestionMarkIndex = spritePath.indexOf("?", lastFoundIndex);
            if (lastDotIndex >= 0 && (lastDotIndex < firstQuestionMarkIndex || firstQuestionMarkIndex < 0)) {
                ie6Path.append(spritePath, lastFoundIndex, lastDotIndex);
                ie6Path.append("-ie6");
                ie6Path.append(spritePath, lastDotIndex, spritePath.length());
            } else if (firstQuestionMarkIndex >= 0) {
                ie6Path.append(spritePath, lastFoundIndex, firstQuestionMarkIndex);
                ie6Path.append("-ie6");
                ie6Path.append(spritePath, firstQuestionMarkIndex, spritePath.length());
            } else {
                ie6Path.append(spritePath, lastFoundIndex, spritePath.length());
                ie6Path.append("-ie6");
            }
            return ie6Path.toString();
        }
        return spritePath;
    }

    private static String computeMd5(byte[] image) {
        String string;
        byte[] buffer = new byte[4069];
        MessageDigest digest = MessageDigest.getInstance("MD5");
        ByteArrayInputStream is = null;
        DigestInputStream digestInputStream = null;
        try {
            is = new ByteArrayInputStream(image);
            digestInputStream = new DigestInputStream(is, digest);
            while (((InputStream)digestInputStream).read(buffer) >= 0) {
            }
            string = new BigInteger(1, digest.digest()).toString(16);
        }
        catch (IOException e) {
            try {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    Closeables.closeQuietly(is);
                    Closeables.closeQuietly(digestInputStream);
                    digest.reset();
                    throw throwable;
                }
            }
            catch (NoSuchAlgorithmException nsaex) {
                throw new RuntimeException(nsaex);
            }
        }
        Closeables.closeQuietly((Closeable)is);
        Closeables.closeQuietly((Closeable)digestInputStream);
        digest.reset();
        return string;
    }
}

