/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.labs.smartsprites;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.io.Closeables;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.math3.util.ArithmeticUtils;
import org.carrot2.labs.smartsprites.SmartSpritesParameters;
import org.carrot2.labs.smartsprites.SpriteImage;
import org.carrot2.labs.smartsprites.SpriteImageDirective;
import org.carrot2.labs.smartsprites.SpriteImageOccurrence;
import org.carrot2.labs.smartsprites.SpriteImageRenderer;
import org.carrot2.labs.smartsprites.SpriteLayoutProperties;
import org.carrot2.labs.smartsprites.SpriteReferenceOccurrence;
import org.carrot2.labs.smartsprites.SpriteReferenceReplacement;
import org.carrot2.labs.smartsprites.message.Message;
import org.carrot2.labs.smartsprites.message.MessageLog;
import org.carrot2.labs.smartsprites.resource.ResourceHandler;
import org.carrot2.util.BufferedImageUtils;
import org.carrot2.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpriteImageBuilder {
    public final SmartSpritesParameters parameters;
    private final MessageLog messageLog;
    private SpriteImageRenderer spriteImageRenderer;
    private ResourceHandler resourceHandler;
    private String timestamp;

    SpriteImageBuilder(SmartSpritesParameters parameters, MessageLog messageLog, ResourceHandler resourceHandler) {
        this.messageLog = messageLog;
        this.parameters = parameters;
        this.resourceHandler = resourceHandler;
        this.spriteImageRenderer = new SpriteImageRenderer(parameters, messageLog);
    }

    Multimap<String, SpriteReferenceReplacement> buildSpriteImages(Map<String, SpriteImageOccurrence> spriteImageOccurrencesBySpriteId, Multimap<String, SpriteReferenceOccurrence> spriteReferenceOccurrencesBySpriteId) {
        this.timestamp = Long.toString(new Date().getTime());
        LinkedListMultimap spriteReplacementsByFile = LinkedListMultimap.create();
        for (Map.Entry spriteReferenceOccurrences : spriteReferenceOccurrencesBySpriteId.asMap().entrySet()) {
            Map<SpriteReferenceOccurrence, SpriteReferenceReplacement> spriteReferenceReplacements = this.buildSpriteReplacements(spriteImageOccurrencesBySpriteId.get(spriteReferenceOccurrences.getKey()), (Collection)spriteReferenceOccurrences.getValue());
            for (SpriteReferenceReplacement spriteReferenceReplacement : spriteReferenceReplacements.values()) {
                spriteReplacementsByFile.put((Object)spriteReferenceReplacement.spriteReferenceOccurrence.cssFile, (Object)spriteReferenceReplacement);
            }
        }
        return spriteReplacementsByFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<SpriteReferenceOccurrence, SpriteReferenceReplacement> buildSpriteReplacements(SpriteImageOccurrence spriteImageOccurrence, Collection<SpriteReferenceOccurrence> spriteReferenceOccurrences) {
        LinkedHashMap images = Maps.newLinkedHashMap();
        for (SpriteReferenceOccurrence spriteReferenceOccurrence : spriteReferenceOccurrences) {
            InputStream is;
            block10: {
                this.messageLog.setCssFile(spriteReferenceOccurrence.cssFile);
                this.messageLog.setLine(spriteReferenceOccurrence.line);
                String realImagePath = this.resourceHandler.getResourcePath(spriteReferenceOccurrence.cssFile, spriteReferenceOccurrence.imagePath);
                is = null;
                try {
                    is = this.resourceHandler.getResourceAsInputStream(realImagePath);
                    if (is != null) {
                        this.messageLog.info(Message.MessageType.READING_IMAGE, realImagePath);
                        BufferedImage image = ImageIO.read(is);
                        if (image != null) {
                            images.put(spriteReferenceOccurrence, image);
                        } else {
                            this.messageLog.warning(Message.MessageType.UNSUPPORTED_INDIVIDUAL_IMAGE_FORMAT, realImagePath);
                        }
                        break block10;
                    }
                    this.messageLog.warning(Message.MessageType.CANNOT_NOT_LOAD_IMAGE, realImagePath, "Can't read input file!");
                }
                catch (IOException e) {
                    try {
                        this.messageLog.warning(Message.MessageType.CANNOT_NOT_LOAD_IMAGE, realImagePath, "Can't read input file!");
                    }
                    catch (Throwable throwable) {
                        Closeables.closeQuietly(is);
                        throw throwable;
                    }
                    Closeables.closeQuietly((Closeable)is);
                    continue;
                }
                Closeables.closeQuietly((Closeable)is);
                continue;
            }
            Closeables.closeQuietly((Closeable)is);
            this.messageLog.setCssFile(null);
        }
        SpriteImage spriteImage = SpriteImageBuilder.buildSpriteImage(spriteImageOccurrence, images, this.messageLog);
        if (spriteImage == null) {
            return Collections.emptyMap();
        }
        BufferedImage[] mergedImages = this.spriteImageRenderer.render(spriteImage);
        this.writeSprite(spriteImage, mergedImages[0], false);
        if (mergedImages[1] != null) {
            this.writeSprite(spriteImage, mergedImages[1], true);
        }
        return spriteImage.spriteReferenceReplacements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSprite(SpriteImage spriteImage, BufferedImage mergedImage, boolean ie6Reduced) {
        BufferedImage imageToWrite;
        SpriteImageOccurrence spriteImageOccurrence = spriteImage.spriteImageOccurrence;
        SpriteImageDirective spriteImageDirective = spriteImageOccurrence.spriteImageDirective;
        ByteArrayOutputStream spriteImageByteArrayOuputStream = new ByteArrayOutputStream();
        if (SpriteImageDirective.SpriteImageFormat.JPG.equals((Object)spriteImageDirective.format)) {
            imageToWrite = new BufferedImage(mergedImage.getWidth(), mergedImage.getHeight(), 5);
            BufferedImageUtils.drawImage(mergedImage, imageToWrite, 0, 0);
        } else {
            imageToWrite = mergedImage;
        }
        try {
            ImageIO.write((RenderedImage)imageToWrite, spriteImageDirective.format.toString(), spriteImageByteArrayOuputStream);
        }
        catch (IOException e) {
            this.messageLog.warning(Message.MessageType.CANNOT_WRITE_SPRITE_IMAGE, spriteImageDirective.imagePath, e.getMessage());
        }
        byte[] spriteImageBytes = spriteImageByteArrayOuputStream.toByteArray();
        String resolvedImagePath = spriteImage.resolveImagePath(spriteImageBytes, this.timestamp, ie6Reduced);
        if (resolvedImagePath.indexOf(63) >= 0) {
            resolvedImagePath = resolvedImagePath.substring(0, resolvedImagePath.indexOf(63));
        }
        String mergedImageFile = this.getImageFile(spriteImageOccurrence.cssFile, resolvedImagePath);
        OutputStream spriteImageOuputStream = null;
        try {
            this.messageLog.info(Message.MessageType.WRITING_SPRITE_IMAGE, mergedImage.getWidth(), mergedImage.getHeight(), spriteImageDirective.spriteId, mergedImageFile);
            spriteImageOuputStream = this.resourceHandler.getResourceAsOutputStream(mergedImageFile);
            spriteImageOuputStream.write(spriteImageBytes);
            Closeables.closeQuietly((Closeable)spriteImageOuputStream);
        }
        catch (IOException e) {
            this.messageLog.warning(Message.MessageType.CANNOT_WRITE_SPRITE_IMAGE, mergedImageFile, e.getMessage());
        }
        finally {
            Closeables.closeQuietly(spriteImageOuputStream);
        }
    }

    String getImageFile(String cssFile, String imagePath) {
        String path = this.resourceHandler.getResourcePath(cssFile, imagePath);
        if (!imagePath.startsWith("/") && this.parameters.hasOutputDir()) {
            return FileUtils.changeRoot(path, this.parameters.getRootDir(), this.parameters.getOutputDir());
        }
        return path;
    }

    static SpriteImage buildSpriteImage(SpriteImageOccurrence spriteImageOccurrence, Map<SpriteReferenceOccurrence, BufferedImage> images, MessageLog messageLog) {
        int spriteHeight;
        SpriteImageDirective.SpriteImageLayout layout = spriteImageOccurrence.spriteImageDirective.layout;
        float spriteScale = spriteImageOccurrence.spriteImageDirective.scaleRatio;
        int leastCommonMultiple = SpriteImageBuilder.calculateLeastCommonMultiple(images, layout);
        boolean vertical = layout.equals((Object)SpriteImageDirective.SpriteImageLayout.VERTICAL);
        int dimension = leastCommonMultiple;
        for (Map.Entry<SpriteReferenceOccurrence, BufferedImage> entry : images.entrySet()) {
            BufferedImage image = entry.getValue();
            SpriteReferenceOccurrence spriteReferenceOcurrence = entry.getKey();
            dimension = Math.max(dimension, vertical ? spriteReferenceOcurrence.getRequiredWidth(image, layout) : spriteReferenceOcurrence.getRequiredHeight(image, layout));
        }
        if (dimension % leastCommonMultiple != 0) {
            dimension += leastCommonMultiple - dimension % leastCommonMultiple;
        }
        int currentOffset = 0;
        LinkedHashMap spriteReplacements = Maps.newLinkedHashMap();
        LinkedHashMap renderedImageToOffset = Maps.newLinkedHashMap();
        for (Map.Entry<SpriteReferenceOccurrence, BufferedImage> entry : images.entrySet()) {
            BufferedImage image;
            SpriteReferenceOccurrence spriteReferenceOccurrence = entry.getKey();
            BufferedImage rendered = spriteReferenceOccurrence.render(image = entry.getValue(), layout, dimension);
            BufferedImageEqualsWrapper imageWrapper = new BufferedImageEqualsWrapper(rendered);
            Integer imageOffset = (Integer)renderedImageToOffset.get(imageWrapper);
            if (imageOffset == null) {
                imageOffset = currentOffset;
                renderedImageToOffset.put(imageWrapper, imageOffset);
                currentOffset += vertical ? rendered.getHeight() : rendered.getWidth();
            }
            float scaledImageWidth = (float)spriteReferenceOccurrence.getRequiredWidth(image, layout) / spriteScale;
            float scaledImageHeight = (float)spriteReferenceOccurrence.getRequiredHeight(image, layout) / spriteScale;
            if ((float)Math.round(scaledImageWidth) != scaledImageWidth || (float)Math.round(scaledImageHeight) != scaledImageHeight) {
                messageLog.warning(Message.MessageType.IMAGE_FRACTIONAL_SCALE_VALUE, spriteReferenceOccurrence.imagePath, Float.valueOf(scaledImageWidth), Float.valueOf(scaledImageHeight));
            }
            int adjustedImageOffset = Math.round((float)imageOffset.intValue() / spriteScale);
            spriteReplacements.put(spriteReferenceOccurrence, spriteReferenceOccurrence.buildReplacement(layout, adjustedImageOffset));
        }
        int spriteWidth = vertical ? dimension : currentOffset;
        int n = spriteHeight = vertical ? currentOffset : dimension;
        if (spriteWidth == 0 || spriteHeight == 0) {
            return null;
        }
        float scaledWidth = (float)spriteWidth / spriteScale;
        float scaledHeight = (float)spriteHeight / spriteScale;
        if ((float)Math.round(scaledWidth) != scaledWidth || (float)Math.round(scaledHeight) != scaledHeight) {
            messageLog.warning(Message.MessageType.FRACTIONAL_SCALE_VALUE, spriteImageOccurrence.spriteImageDirective.spriteId, Float.valueOf(scaledWidth), Float.valueOf(scaledHeight));
        }
        BufferedImage sprite = new BufferedImage(spriteWidth, spriteHeight, 6);
        for (Map.Entry entry : renderedImageToOffset.entrySet()) {
            BufferedImageUtils.drawImage(((BufferedImageEqualsWrapper)entry.getKey()).image, sprite, vertical ? 0 : (Integer)entry.getValue(), vertical ? (Integer)entry.getValue() : 0);
        }
        return new SpriteImage(sprite, spriteImageOccurrence, spriteReplacements, spriteWidth, spriteHeight, spriteScale);
    }

    static int calculateLeastCommonMultiple(Map<SpriteReferenceOccurrence, BufferedImage> images, SpriteImageDirective.SpriteImageLayout layout) {
        int leastCommonMultiple = 1;
        for (Map.Entry<SpriteReferenceOccurrence, BufferedImage> entry : images.entrySet()) {
            BufferedImage image = entry.getValue();
            SpriteReferenceOccurrence spriteReferenceOccurrence = entry.getKey();
            if (image == null || !SpriteLayoutProperties.SpriteAlignment.REPEAT.equals((Object)spriteReferenceOccurrence.spriteReferenceDirective.spriteLayoutProperties.alignment)) continue;
            if (SpriteImageDirective.SpriteImageLayout.VERTICAL.equals((Object)layout)) {
                leastCommonMultiple = ArithmeticUtils.lcm((int)leastCommonMultiple, (int)spriteReferenceOccurrence.getRequiredWidth(image, layout));
                continue;
            }
            leastCommonMultiple = ArithmeticUtils.lcm((int)leastCommonMultiple, (int)spriteReferenceOccurrence.getRequiredHeight(image, layout));
        }
        return leastCommonMultiple;
    }

    static Map<Integer, SpriteReferenceReplacement> getSpriteReplacementsByLineNumber(Collection<SpriteReferenceReplacement> spriteReferenceReplacements) {
        HashMap result = Maps.newHashMap();
        for (SpriteReferenceReplacement spriteReferenceReplacement : spriteReferenceReplacements) {
            result.put(spriteReferenceReplacement.spriteReferenceOccurrence.line, spriteReferenceReplacement);
        }
        return result;
    }

    static Map<Integer, SpriteImageOccurrence> getSpriteImageOccurrencesByLineNumber(Collection<SpriteImageOccurrence> spriteImageOccurrences) {
        HashMap result = Maps.newHashMap();
        for (SpriteImageOccurrence spriteImageOccurrence : spriteImageOccurrences) {
            result.put(spriteImageOccurrence.line, spriteImageOccurrence);
        }
        return result;
    }

    static final class BufferedImageEqualsWrapper {
        BufferedImage image;

        BufferedImageEqualsWrapper(BufferedImage image) {
            this.image = image;
        }

        public boolean equals(Object obj) {
            boolean equal;
            if (!(obj instanceof BufferedImageEqualsWrapper)) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            BufferedImage other = ((BufferedImageEqualsWrapper)obj).image;
            boolean bl = equal = other.getWidth() == this.image.getWidth() && other.getHeight() == other.getHeight() && other.getType() == this.image.getType();
            if (equal) {
                for (int y = 0; y < this.image.getHeight(); ++y) {
                    for (int x = 0; x < this.image.getWidth(); ++x) {
                        if (BufferedImageEqualsWrapper.ignoreFullTransparency(this.image.getRGB(x, y)) == BufferedImageEqualsWrapper.ignoreFullTransparency(other.getRGB(x, y))) continue;
                        return false;
                    }
                }
            }
            return equal;
        }

        public int hashCode() {
            if (this.image == null) {
                return 0;
            }
            int hash = this.image.getWidth() ^ this.image.getHeight() << 16;
            int xIncrement = this.image.getWidth() > 7 ? this.image.getWidth() >> 2 : 1;
            int yIncrement = this.image.getHeight() > 7 ? this.image.getHeight() >> 2 : 1;
            for (int y = 0; y < this.image.getHeight(); y += yIncrement) {
                for (int x = 0; x < this.image.getWidth(); x += xIncrement) {
                    hash ^= BufferedImageEqualsWrapper.ignoreFullTransparency(this.image.getRGB(x, y));
                }
            }
            return hash;
        }

        private static int ignoreFullTransparency(int pixel) {
            if ((pixel & 0xFF000000) == 0) {
                return 0;
            }
            return pixel;
        }
    }
}

