/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.labs.smartsprites.ant;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.resources.FileResource;
import org.carrot2.labs.smartsprites.SmartSpritesParameters;
import org.carrot2.labs.smartsprites.SpriteBuilder;
import org.carrot2.labs.smartsprites.message.Message;
import org.carrot2.labs.smartsprites.message.MessageLog;
import org.carrot2.labs.smartsprites.message.MessageSink;
import org.carrot2.util.EnumUtils;

public class SmartSpritesTask
extends Task {
    private String rootDir;
    private String outputDir;
    private String documentRootDir;
    private Message.MessageLevel logLevel;
    private Message.MessageLevel failOnLevel = Message.MessageLevel.ERROR;
    private String cssFileSuffix = "-sprite";
    private String cssFileEncoding = "UTF-8";
    private SmartSpritesParameters.PngDepth spritePngDepth = SmartSpritesParameters.DEFAULT_SPRITE_PNG_DEPTH;
    private boolean spritePngIe6 = false;
    private List<String> cssFiles = Lists.newArrayList();

    public void setRootDir(File dir) {
        this.rootDir = dir.getPath();
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir.getPath();
    }

    public void setDocumentRootDir(File documentRootDir) {
        this.documentRootDir = documentRootDir.getPath();
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = this.getLogLevelFromString(logLevel, Message.MessageLevel.INFO);
    }

    public void setFailOnLevel(String failOnLevel) {
        this.failOnLevel = this.getLogLevelFromString(failOnLevel, Message.MessageLevel.ERROR);
    }

    private Message.MessageLevel getLogLevelFromString(String logLevel, Message.MessageLevel defaultLevel) {
        try {
            return Message.MessageLevel.valueOf(logLevel);
        }
        catch (Exception e) {
            return defaultLevel;
        }
    }

    public void setCssFileEncoding(String cssFileEncoding) {
        this.cssFileEncoding = cssFileEncoding;
    }

    public void setCssFileSuffix(String cssFileSuffix) {
        this.cssFileSuffix = cssFileSuffix;
    }

    public void setSpritePngDepth(String spritePngDepthString) {
        this.spritePngDepth = EnumUtils.valueOf(spritePngDepthString, SmartSpritesParameters.PngDepth.class, SmartSpritesParameters.DEFAULT_SPRITE_PNG_DEPTH);
    }

    public void setSpritePngIe6(boolean spritePngIe6) {
        this.spritePngIe6 = spritePngIe6;
    }

    public void execute() throws BuildException {
        SmartSpritesParameters parameters = new SmartSpritesParameters(this.rootDir, this.cssFiles, this.outputDir, this.documentRootDir, this.logLevel, this.cssFileSuffix, this.spritePngDepth, this.spritePngIe6, this.cssFileEncoding);
        FailureDetectorMessageSink failureDetectorMessageSink = new FailureDetectorMessageSink();
        MessageLog log = new MessageLog(new AntLogMessageSink(), failureDetectorMessageSink);
        if (parameters.validate(log)) {
            try {
                new SpriteBuilder(parameters, log).buildSprites();
            }
            catch (FileNotFoundException e) {
                throw new BuildException((Throwable)e);
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
        }
        if (failureDetectorMessageSink.shouldFail) {
            throw new BuildException(failureDetectorMessageSink.failureLevel.name() + " messages found");
        }
    }

    public void addConfiguredFileset(FileSet fileset) {
        Iterator it = fileset.iterator();
        while (it.hasNext()) {
            this.cssFiles.add(((FileResource)it.next()).getFile().getPath());
        }
    }

    private class FailureDetectorMessageSink
    implements MessageSink {
        boolean shouldFail = false;
        Message.MessageLevel failureLevel = null;

        private FailureDetectorMessageSink() {
        }

        public void add(Message message) {
            if (SmartSpritesTask.this.failOnLevel != null && Message.MessageLevel.COMPARATOR.compare(message.level, SmartSpritesTask.this.failOnLevel) >= 0 && message.level != Message.MessageLevel.STATUS) {
                this.failureLevel = message.level;
                this.shouldFail = true;
            }
        }
    }

    private class AntLogMessageSink
    implements MessageSink {
        private AntLogMessageSink() {
        }

        public void add(Message message) {
            if (Message.MessageLevel.COMPARATOR.compare(message.level, SmartSpritesTask.this.logLevel) >= 0) {
                SmartSpritesTask.this.log(message.toString());
            }
        }
    }
}

