/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.carrot2.util.PathUtils;

public class FileUtils {
    public static File getCanonicalOrAbsoluteFile(String path) {
        File file = new File(path);
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            return file.getAbsoluteFile();
        }
    }

    public static String changeRoot(String file, String oldRoot, String newRoot) {
        String relativePath = PathUtils.getRelativeFilePath(oldRoot, file);
        return FilenameUtils.concat((String)newRoot, (String)relativePath);
    }

    public static String canonicalize(String path, String separator) {
        String replaced = path;
        String toReplace = null;
        String separatorEscaped = Pattern.quote(separator);
        Pattern pattern = Pattern.compile("[^" + separatorEscaped + "\\.]+" + separatorEscaped + "\\.\\." + separatorEscaped + "?");
        while (!replaced.equals(toReplace)) {
            toReplace = replaced;
            replaced = pattern.matcher(toReplace).replaceFirst("");
        }
        return replaced;
    }

    public static void deleteThrowingExceptions(File ... files) throws IOException {
        if (files == null) {
            return;
        }
        ArrayList undeletedFiles = Lists.newArrayList();
        for (File file : files) {
            if (file == null || !file.exists() || file.delete()) continue;
            undeletedFiles.add(file.getPath());
        }
        if (!undeletedFiles.isEmpty()) {
            throw new IOException("Unable to delete files: " + undeletedFiles.toString());
        }
    }

    public static void mkdirsThrowingExceptions(File dirs) throws IOException {
        if (dirs.exists()) {
            return;
        }
        if (!dirs.mkdirs()) {
            throw new IOException("Unable to create directories: " + dirs.getPath());
        }
    }

    public static boolean isFileInParent(File file, File parent) {
        File fileParent = file.getParentFile();
        if (fileParent == null) {
            return false;
        }
        if (fileParent.equals(parent)) {
            return true;
        }
        return FileUtils.isFileInParent(fileParent, parent);
    }
}

