/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base;

import com.google.appengine.repackaged.com.google.common.base.Range;
import com.google.common.annotations.GwtCompatible;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
public final class Ranges {
    private static final Range<Comparable<Object>> EMPTY_RANGE = new EmptyRange<Comparable<Object>>();

    private Ranges() {
    }

    public static <V extends Comparable<? super V>> Range<V> newRange(V min, V max) {
        if (max.compareTo(min) > -1) {
            return new RangeClosed<V>(min, max);
        }
        return Ranges.emptyRange();
    }

    public static <V extends Comparable<? super V>> Range<V> emptyRange() {
        return EMPTY_RANGE;
    }

    public static <V extends Comparable<? super V>> Range<V> intersect(Range<V> aRange, Range<V> ... moreRanges) {
        Range<V> result = aRange;
        for (Range<V> range : moreRanges) {
            result = result.intersection(range);
        }
        return result;
    }

    public static <V extends Comparable<? super V>> Range<V> enclose(Range<V> aRange, Range<V> ... moreRanges) {
        Range<V> result = aRange;
        for (Range<V> range : moreRanges) {
            result = result.enclosure(range);
        }
        return result;
    }

    public static <V extends Comparable<? super V>> Range<V> rangeOf(V ... values) {
        Object min = null;
        Object max = null;
        boolean isEmpty = true;
        for (V value : values) {
            if (value == null) continue;
            if (isEmpty) {
                isEmpty = false;
                min = value;
                max = value;
                continue;
            }
            if (value.compareTo(min) < 0) {
                min = value;
            }
            if (value.compareTo(max) <= 0) continue;
            max = value;
        }
        return isEmpty ? Ranges.emptyRange() : Ranges.newRange(min, max);
    }

    public static Range<Integer> encloseInts(int ... values) {
        if (values.length == 0) {
            return Ranges.emptyRange();
        }
        int min = values[0];
        int max = values[0];
        for (int value : values) {
            if (min > value) {
                min = value;
            }
            if (max >= value) continue;
            max = value;
        }
        return Ranges.newRange(min, max);
    }

    public static Range<Long> encloseLongs(long ... values) {
        if (values.length == 0) {
            return Ranges.emptyRange();
        }
        long min = values[0];
        long max = values[0];
        for (long value : values) {
            if (min > value) {
                min = value;
            }
            if (max >= value) continue;
            max = value;
        }
        return Ranges.newRange(min, max);
    }

    public static Range<Double> encloseDoubles(double ... values) {
        if (values.length == 0) {
            return Ranges.emptyRange();
        }
        double min = values[0];
        double max = values[0];
        for (double value : values) {
            if (min > value) {
                min = value;
            }
            if (!(max < value)) continue;
            max = value;
        }
        return Ranges.newRange(min, max);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RangeClosed<V extends Comparable<? super V>>
    implements Range<V> {
        private final V min;
        private final V max;

        RangeClosed(V min, V max) {
            if (min == null) {
                throw new NullPointerException("Parameter 'min' is null.");
            }
            if (max == null) {
                throw new NullPointerException("Parameter 'max' is null.");
            }
            if (min.compareTo(max) > 0) {
                throw new IllegalArgumentException("Parameter 'min' cannot be greater than Parameter 'max'.");
            }
            this.min = min;
            this.max = max;
        }

        @Override
        public boolean contains(V value) {
            return value != null && this.min.compareTo(value) < 1 && this.max.compareTo(value) > -1;
        }

        @Override
        public Range<V> enclose(V value) {
            if (value == null) {
                return this;
            }
            if (this.isEmpty()) {
                return new RangeClosed<V>(value, value);
            }
            return this.min.compareTo(value) > 0 ? new RangeClosed(value, this.max) : (this.max.compareTo(value) < 0 ? new RangeClosed<V>(this.min, value) : this);
        }

        @Override
        public Range<V> enclosure(Range<V> range) {
            if (range.isEmpty()) {
                return this;
            }
            if (this.isEmpty()) {
                return range;
            }
            V oMin = range.min();
            V oMax = range.max();
            return new RangeClosed<V>(oMin.compareTo(this.min) < 0 ? oMin : this.min, oMax.compareTo(this.max) > 0 ? oMax : this.max);
        }

        public String toString() {
            return "[Range:" + this.min + ", " + this.max + "]";
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof Range) {
                Range c = (Range)o;
                try {
                    if (c.isEmpty()) {
                        return false;
                    }
                    return c.min().equals(this.min) && c.max().equals(this.max);
                }
                catch (ClassCastException e) {
                    return false;
                }
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.min.hashCode() * 555557 + this.max.hashCode();
        }

        @Override
        public Range<V> intersection(Range<V> range) {
            if (!this.intersects(range)) {
                return Ranges.emptyRange();
            }
            V oMin = range.min();
            V oMax = range.max();
            return new RangeClosed<V>(oMin.compareTo(this.min) > 0 ? oMin : this.min, oMax.compareTo(this.max) < 0 ? oMax : this.max);
        }

        @Override
        public boolean intersects(Range<V> range) {
            if (range.isEmpty()) {
                return false;
            }
            return this.max.compareTo(range.min()) > -1 && this.min.compareTo(range.max()) < 1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public V max() {
            return this.max;
        }

        @Override
        public V min() {
            return this.min;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmptyRange<V extends Comparable<? super V>>
    implements Range<V> {
        @Override
        public boolean contains(V value) {
            return false;
        }

        @Override
        public Range<V> enclose(V value) {
            return Ranges.newRange(value, value);
        }

        @Override
        public Range<V> enclosure(Range<V> range) {
            return range;
        }

        @Override
        public V max() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean equals(Object o) {
            return this == o;
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public Range<V> intersection(Range<V> range) {
            return this;
        }

        @Override
        public boolean intersects(Range<V> range) {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public V min() {
            throw new NoSuchElementException();
        }

        public String toString() {
            return "[Empty Range]";
        }
    }
}

