/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.interceptor;

import com.vaadin.external.org.slf4j.Logger;
import com.vaadin.external.org.slf4j.LoggerFactory;
import java.io.IOException;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.ApplicationConfig;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventListenerAdapter;
import org.atmosphere.cpr.AtmosphereResourceImpl;

public class AtmosphereResourceLifecycleInterceptor
implements AtmosphereInterceptor {
    private String method = "GET";
    private static final Logger logger = LoggerFactory.getLogger(AtmosphereResourceLifecycleInterceptor.class);

    @Override
    public void configure(AtmosphereConfig config) {
        String s = config.getInitParameter(ApplicationConfig.ATMOSPHERERESOURCE_INTERCEPTOR_METHOD);
        if (s != null) {
            this.method = s;
        }
    }

    @Override
    public Action inspect(AtmosphereResource r) {
        switch (r.transport()) {
            case JSONP: 
            case AJAX: 
            case LONG_POLLING: {
                r.resumeOnBroadcast(true);
                break;
            }
        }
        return Action.CONTINUE;
    }

    @Override
    public void postInspect(final AtmosphereResource r) {
        if (r.transport().equals((Object)AtmosphereResource.TRANSPORT.UNDEFINED)) {
            return;
        }
        if (!((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r)).action().equals(Action.CANCELLED) && r.getRequest().getMethod().equalsIgnoreCase(this.method)) {
            r.addEventListener(new AtmosphereResourceEventListenerAdapter(){

                @Override
                public void onBroadcast(AtmosphereResourceEvent event) {
                    switch (r.transport()) {
                        case JSONP: 
                        case AJAX: 
                        case LONG_POLLING: {
                            break;
                        }
                        default: {
                            try {
                                r.getResponse().flushBuffer();
                                break;
                            }
                            catch (IOException e) {
                                logger.trace("", (Throwable)e);
                            }
                        }
                    }
                }
            }).suspend();
        }
    }

    public String toString() {
        return "Atmosphere LifeCycle";
    }
}

