/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.collect;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableCollection;
import com.google.appengine.repackaged.com.google.common.collect.Iterators;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.collect.RegularImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.UnmodifiableIterator;
import com.google.common.annotations.GwtCompatible;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(serializable=true)
public abstract class ImmutableList<E>
extends ImmutableCollection<E>
implements List<E>,
RandomAccess {
    private static final ImmutableList<?> EMPTY_IMMUTABLE_LIST = new EmptyImmutableList();

    public static <E> ImmutableList<E> of() {
        return EMPTY_IMMUTABLE_LIST;
    }

    public static <E> ImmutableList<E> of(E element) {
        return new RegularImmutableList(ImmutableList.copyIntoArray(element));
    }

    public static <E> ImmutableList<E> of(E e1, E e2) {
        return new RegularImmutableList(ImmutableList.copyIntoArray(e1, e2));
    }

    public static <E> ImmutableList<E> of(E e1, E e2, E e3) {
        return new RegularImmutableList(ImmutableList.copyIntoArray(e1, e2, e3));
    }

    public static <E> ImmutableList<E> of(E e1, E e2, E e3, E e4) {
        return new RegularImmutableList(ImmutableList.copyIntoArray(e1, e2, e3, e4));
    }

    public static <E> ImmutableList<E> of(E e1, E e2, E e3, E e4, E e5) {
        return new RegularImmutableList(ImmutableList.copyIntoArray(e1, e2, e3, e4, e5));
    }

    public static <E> ImmutableList<E> of(E ... elements) {
        return elements.length == 0 ? ImmutableList.of() : new RegularImmutableList(ImmutableList.copyIntoArray(elements));
    }

    public static <E> ImmutableList<E> copyOf(Iterable<? extends E> elements) {
        if (elements instanceof ImmutableList) {
            ImmutableList list = (ImmutableList)elements;
            return list;
        }
        if (elements instanceof Collection) {
            Collection coll = (Collection)elements;
            return ImmutableList.copyOfInternal(coll);
        }
        return ImmutableList.copyOfInternal(Lists.newArrayList(elements));
    }

    public static <E> ImmutableList<E> copyOf(Iterator<? extends E> elements) {
        return ImmutableList.copyOfInternal(Lists.newArrayList(elements));
    }

    private static <E> ImmutableList<E> copyOfInternal(ArrayList<? extends E> list) {
        return list.isEmpty() ? ImmutableList.of() : new RegularImmutableList(ImmutableList.nullChecked(list.toArray()));
    }

    private static Object[] nullChecked(Object[] array) {
        int len = array.length;
        for (int i = 0; i < len; ++i) {
            if (array[i] != null) continue;
            throw new NullPointerException("at index " + i);
        }
        return array;
    }

    private static <E> ImmutableList<E> copyOfInternal(Collection<? extends E> collection) {
        int size = collection.size();
        return size == 0 ? ImmutableList.of() : ImmutableList.createFromIterable(collection, size);
    }

    ImmutableList() {
    }

    @Override
    public abstract UnmodifiableIterator<E> iterator();

    @Override
    public abstract int indexOf(@Nullable Object var1);

    @Override
    public abstract int lastIndexOf(@Nullable Object var1);

    @Override
    public abstract ImmutableList<E> subList(int var1, int var2);

    @Override
    public final boolean addAll(int index, Collection<? extends E> newElements) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final E set(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void add(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final E remove(int index) {
        throw new UnsupportedOperationException();
    }

    private static Object[] copyIntoArray(Object ... source) {
        Object[] array = new Object[source.length];
        int index = 0;
        for (Object element : source) {
            if (element == null) {
                throw new NullPointerException("at index " + index);
            }
            array[index++] = element;
        }
        return array;
    }

    private static <E> ImmutableList<E> createFromIterable(Iterable<?> source, int estimatedSize) {
        Object[] array = new Object[estimatedSize];
        int index = 0;
        for (Object element : source) {
            if (index == estimatedSize) {
                estimatedSize = (estimatedSize / 2 + 1) * 3;
                array = ImmutableList.copyOf(array, estimatedSize);
            }
            if (element == null) {
                throw new NullPointerException("at index " + index);
            }
            array[index++] = element;
        }
        if (index == 0) {
            return ImmutableList.of();
        }
        if (index != estimatedSize) {
            array = ImmutableList.copyOf(array, index);
        }
        return new RegularImmutableList(array, 0, index);
    }

    private static Object[] copyOf(Object[] oldArray, int newSize) {
        Object[] newArray = new Object[newSize];
        System.arraycopy(oldArray, 0, newArray, 0, Math.min(oldArray.length, newSize));
        return newArray;
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Use SerializedForm");
    }

    @Override
    Object writeReplace() {
        return new SerializedForm(this.toArray());
    }

    public static <E> Builder<E> builder() {
        return new Builder();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder<E> {
        private final ArrayList<E> contents = Lists.newArrayList();

        public Builder<E> add(E element) {
            Preconditions.checkNotNull(element, "element cannot be null");
            this.contents.add(element);
            return this;
        }

        public Builder<E> addAll(Iterable<? extends E> elements) {
            if (elements instanceof Collection) {
                Collection collection = (Collection)elements;
                this.contents.ensureCapacity(this.contents.size() + collection.size());
            }
            for (E elem : elements) {
                Preconditions.checkNotNull(elem, "elements contains a null");
                this.contents.add(elem);
            }
            return this;
        }

        public ImmutableList<E> build() {
            return ImmutableList.copyOf(this.contents);
        }
    }

    private static class SerializedForm
    implements Serializable {
        final Object[] elements;
        private static final long serialVersionUID = 0L;

        SerializedForm(Object[] elements) {
            this.elements = elements;
        }

        Object readResolve() {
            return ImmutableList.of(this.elements);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class EmptyImmutableList
    extends ImmutableList<Object> {
        private static final Object[] EMPTY_ARRAY = new Object[0];

        EmptyImmutableList() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean contains(Object target) {
            return false;
        }

        @Override
        public UnmodifiableIterator<Object> iterator() {
            return Iterators.emptyIterator();
        }

        @Override
        public Object[] toArray() {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            if (a.length > 0) {
                a[0] = null;
            }
            return a;
        }

        @Override
        public Object get(int index) {
            Preconditions.checkElementIndex(index, 0);
            throw new AssertionError((Object)"unreachable");
        }

        @Override
        public int indexOf(Object target) {
            return -1;
        }

        @Override
        public int lastIndexOf(Object target) {
            return -1;
        }

        @Override
        public ImmutableList<Object> subList(int fromIndex, int toIndex) {
            Preconditions.checkPositionIndexes(fromIndex, toIndex, 0);
            return this;
        }

        @Override
        public ListIterator<Object> listIterator() {
            return Collections.emptyList().listIterator();
        }

        @Override
        public ListIterator<Object> listIterator(int start) {
            Preconditions.checkPositionIndex(start, 0);
            return Collections.emptyList().listIterator();
        }

        @Override
        public boolean containsAll(Collection<?> targets) {
            return targets.isEmpty();
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object instanceof List) {
                List that = (List)object;
                return that.isEmpty();
            }
            return false;
        }

        @Override
        public int hashCode() {
            return 1;
        }

        @Override
        public String toString() {
            return "[]";
        }
    }
}

