/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.labs.smartsprites;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.io.Closeables;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.carrot2.labs.smartsprites.SmartSpritesParameters;
import org.carrot2.labs.smartsprites.SpriteDirectiveOccurrenceCollector;
import org.carrot2.labs.smartsprites.SpriteImageBuilder;
import org.carrot2.labs.smartsprites.SpriteImageDirective;
import org.carrot2.labs.smartsprites.SpriteImageOccurrence;
import org.carrot2.labs.smartsprites.SpriteReferenceOccurrence;
import org.carrot2.labs.smartsprites.SpriteReferenceReplacement;
import org.carrot2.labs.smartsprites.message.LevelCounterMessageSink;
import org.carrot2.labs.smartsprites.message.Message;
import org.carrot2.labs.smartsprites.message.MessageLog;
import org.carrot2.labs.smartsprites.resource.FileSystemResourceHandler;
import org.carrot2.labs.smartsprites.resource.ResourceHandler;
import org.carrot2.util.PathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpriteBuilder {
    private static final HashSet<String> OVERRIDING_PROPERTIES = Sets.newHashSet((Object[])new String[]{"background-position", "background-image"});
    public final SmartSpritesParameters parameters;
    private final MessageLog messageLog;
    private final SpriteDirectiveOccurrenceCollector spriteDirectiveOccurrenceCollector;
    private final SpriteImageBuilder spriteImageBuilder;
    private ResourceHandler resourceHandler;

    public SpriteBuilder(SmartSpritesParameters parameters, MessageLog messageLog) {
        this(parameters, messageLog, new FileSystemResourceHandler(parameters.getDocumentRootDir(), parameters.getCssFileEncoding(), messageLog));
    }

    public SpriteBuilder(SmartSpritesParameters parameters, MessageLog messageLog, ResourceHandler resourceHandler) {
        this.messageLog = messageLog;
        this.parameters = parameters;
        this.resourceHandler = resourceHandler;
        this.spriteDirectiveOccurrenceCollector = new SpriteDirectiveOccurrenceCollector(messageLog, resourceHandler);
        this.spriteImageBuilder = new SpriteImageBuilder(parameters, messageLog, resourceHandler);
    }

    public void buildSprites() throws FileNotFoundException, IOException {
        ArrayList filePaths;
        if (!this.parameters.validate(this.messageLog)) {
            return;
        }
        if (this.parameters.getCssFiles() != null && !this.parameters.getCssFiles().isEmpty()) {
            filePaths = this.parameters.getCssFiles();
            if (StringUtils.isNotBlank((CharSequence)this.parameters.getOutputDir())) {
                this.filterFilesOutsideRootDir(filePaths);
            }
            Iterator it = filePaths.iterator();
            while (it.hasNext()) {
                String path = (String)it.next();
                File file = new File(path);
                if (file.exists()) {
                    if (file.isFile()) continue;
                    this.messageLog.warning(Message.MessageType.CSS_PATH_IS_NOT_A_FILE, path);
                    it.remove();
                    continue;
                }
                this.messageLog.warning(Message.MessageType.CSS_FILE_DOES_NOT_EXIST, path);
                it.remove();
            }
        } else {
            ArrayList files = Lists.newArrayList((Iterable)FileUtils.listFiles((File)this.parameters.getRootDirFile(), (String[])new String[]{"css"}, (boolean)true));
            Collections.sort(files, new Comparator<File>(){

                @Override
                public int compare(File f1, File f2) {
                    return f1.getAbsolutePath().compareTo(f2.getAbsolutePath());
                }
            });
            filePaths = Lists.newArrayList();
            for (File file : files) {
                filePaths.add(file.getPath());
            }
        }
        this.buildSprites(filePaths);
    }

    private void filterFilesOutsideRootDir(Collection<String> filePaths) throws IOException {
        Iterator<String> it = filePaths.iterator();
        while (it.hasNext()) {
            String filePath = it.next();
            if (org.carrot2.util.FileUtils.isFileInParent(new File(filePath), this.parameters.getRootDirFile())) continue;
            it.remove();
            this.messageLog.warning(Message.MessageType.IGNORING_CSS_FILE_OUTSIDE_OF_ROOT_DIR, filePath);
        }
    }

    public void buildSprites(Collection<String> filePaths) throws FileNotFoundException, IOException {
        long start = System.currentTimeMillis();
        LevelCounterMessageSink levelCounter = new LevelCounterMessageSink();
        this.messageLog.addMessageSink(levelCounter);
        Multimap<String, SpriteImageOccurrence> spriteImageOccurrencesByFile = this.spriteDirectiveOccurrenceCollector.collectSpriteImageOccurrences(filePaths);
        Map<String, SpriteImageOccurrence> spriteImageOccurrencesBySpriteId = this.spriteDirectiveOccurrenceCollector.mergeSpriteImageOccurrences(spriteImageOccurrencesByFile);
        LinkedHashMap spriteImageDirectivesBySpriteId = Maps.newLinkedHashMap();
        for (Map.Entry<String, SpriteImageOccurrence> entry : spriteImageOccurrencesBySpriteId.entrySet()) {
            spriteImageDirectivesBySpriteId.put(entry.getKey(), entry.getValue().spriteImageDirective);
        }
        Multimap<String, SpriteReferenceOccurrence> spriteEntriesByFile = this.spriteDirectiveOccurrenceCollector.collectSpriteReferenceOccurrences(filePaths, (Map<String, SpriteImageDirective>)spriteImageDirectivesBySpriteId);
        Multimap<String, SpriteReferenceOccurrence> spriteReferenceOccurrencesBySpriteId = SpriteDirectiveOccurrenceCollector.mergeSpriteReferenceOccurrences(spriteEntriesByFile);
        this.messageLog.setCssFile(null);
        Multimap<String, SpriteReferenceReplacement> spriteReplacementsByFile = this.spriteImageBuilder.buildSpriteImages(spriteImageOccurrencesBySpriteId, spriteReferenceOccurrencesBySpriteId);
        this.rewriteCssFiles(spriteImageOccurrencesByFile, spriteReplacementsByFile);
        long stop = System.currentTimeMillis();
        if (levelCounter.getWarnCount() > 0) {
            this.messageLog.status(Message.MessageType.PROCESSING_COMPLETED_WITH_WARNINGS, stop - start, levelCounter.getWarnCount());
        } else {
            this.messageLog.status(Message.MessageType.PROCESSING_COMPLETED, stop - start);
        }
    }

    private void rewriteCssFiles(Multimap<String, SpriteImageOccurrence> spriteImageOccurrencesByFile, Multimap<String, SpriteReferenceReplacement> spriteReplacementsByFile) throws IOException {
        if (spriteReplacementsByFile.isEmpty()) {
            for (Map.Entry entry : spriteImageOccurrencesByFile.asMap().entrySet()) {
                String cssFile = (String)entry.getKey();
                this.createProcessedCss(cssFile, SpriteImageBuilder.getSpriteImageOccurrencesByLineNumber(spriteImageOccurrencesByFile.get((Object)cssFile)), new HashMap<Integer, SpriteReferenceReplacement>());
            }
        } else {
            for (Map.Entry entry : spriteReplacementsByFile.asMap().entrySet()) {
                String cssFile = (String)entry.getKey();
                Map<Integer, SpriteReferenceReplacement> spriteReplacementsByLineNumber = SpriteImageBuilder.getSpriteReplacementsByLineNumber((Collection)entry.getValue());
                this.createProcessedCss(cssFile, SpriteImageBuilder.getSpriteImageOccurrencesByLineNumber(spriteImageOccurrencesByFile.get((Object)cssFile)), spriteReplacementsByLineNumber);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createProcessedCss(String originalCssFile, Map<Integer, SpriteImageOccurrence> spriteImageOccurrencesByLineNumber, Map<Integer, SpriteReferenceReplacement> spriteReplacementsByLineNumber) throws IOException {
        String processedCssFile = this.getProcessedCssFile(originalCssFile);
        BufferedReader originalCssReader = new BufferedReader(this.resourceHandler.getResourceAsReader(originalCssFile));
        this.messageLog.setCssFile(null);
        this.messageLog.info(Message.MessageType.CREATING_CSS_STYLE_SHEET, processedCssFile);
        this.messageLog.info(Message.MessageType.READING_CSS, originalCssFile);
        BufferedWriter processedCssWriter = new BufferedWriter(this.resourceHandler.getResourceAsWriter(processedCssFile));
        this.messageLog.info(Message.MessageType.WRITING_CSS, processedCssFile);
        int originalCssLineNumber = -1;
        int lastReferenceReplacementLine = -1;
        try {
            String originalCssLine;
            this.messageLog.setCssFile(originalCssFile);
            originalCssFile = originalCssFile.replace(File.separatorChar, '/');
            while ((originalCssLine = originalCssReader.readLine()) != null) {
                this.messageLog.setLine(++originalCssLineNumber);
                if (originalCssLine.contains("}")) {
                    lastReferenceReplacementLine = -1;
                }
                SpriteImageOccurrence spriteImageOccurrence = spriteImageOccurrencesByLineNumber.get(originalCssLineNumber);
                SpriteReferenceReplacement spriteReferenceReplacement = spriteReplacementsByLineNumber.get(originalCssLineNumber);
                if (spriteImageOccurrence != null) continue;
                if (spriteReferenceReplacement != null) {
                    boolean important = spriteReferenceReplacement.spriteReferenceOccurrence.important;
                    lastReferenceReplacementLine = originalCssLineNumber;
                    processedCssWriter.write("  background-image: url('" + this.getRelativeToReplacementLocation(spriteReferenceReplacement.spriteImage.resolvedPath, originalCssFile, spriteReferenceReplacement) + "')" + (important ? " !important" : "") + ";\n");
                    if (spriteReferenceReplacement.spriteImage.hasReducedForIe6) {
                        processedCssWriter.write("  -background-image: url('" + this.getRelativeToReplacementLocation(spriteReferenceReplacement.spriteImage.resolvedPathIe6, originalCssFile, spriteReferenceReplacement) + "')" + (important ? " !important" : "") + ";\n");
                    }
                    processedCssWriter.write("  background-position: " + spriteReferenceReplacement.horizontalPositionString + " " + spriteReferenceReplacement.verticalPositionString + (important ? " !important" : "") + ";\n");
                    float scale = spriteReferenceReplacement.spriteImage.scaleRatio;
                    if (scale == 1.0f) continue;
                    processedCssWriter.write("  background-size: " + Math.round((float)spriteReferenceReplacement.spriteImage.spriteWidth / scale) + "px " + Math.round((float)spriteReferenceReplacement.spriteImage.spriteHeight / scale) + "px;\n");
                    continue;
                }
                if (lastReferenceReplacementLine >= 0) {
                    for (String property : OVERRIDING_PROPERTIES) {
                        if (!originalCssLine.contains(property)) continue;
                        this.messageLog.warning(Message.MessageType.OVERRIDING_PROPERTY_FOUND, property, lastReferenceReplacementLine);
                    }
                }
                processedCssWriter.write(originalCssLine + "\n");
            }
            this.messageLog.setCssFile(null);
        }
        finally {
            Closeables.closeQuietly((Closeable)originalCssReader);
            processedCssWriter.close();
        }
    }

    private String getRelativeToReplacementLocation(String imagePath, String originalCssFile, SpriteReferenceReplacement spriteReferenceReplacement) {
        String declaringCssPath = spriteReferenceReplacement.spriteImage.spriteImageOccurrence.cssFile.replace(File.separatorChar, '/');
        String declarationReplacementRelativePath = PathUtils.getRelativeFilePath(originalCssFile.substring(0, originalCssFile.lastIndexOf(47)), declaringCssPath.substring(0, declaringCssPath.lastIndexOf(47))).replace(File.separatorChar, '/');
        String imagePathRelativeToReplacement = org.carrot2.util.FileUtils.canonicalize((StringUtils.isEmpty((CharSequence)declarationReplacementRelativePath) || StringUtils.indexOfDifference((CharSequence)originalCssFile, (CharSequence)declaringCssPath) <= 0 ? "" : declarationReplacementRelativePath + '/') + imagePath, "/");
        return imagePathRelativeToReplacement;
    }

    String getProcessedCssFile(String originalCssFile) {
        int lastDotIndex = originalCssFile.lastIndexOf(46);
        String processedCssFile = lastDotIndex >= 0 ? originalCssFile.substring(0, lastDotIndex) + this.parameters.getCssFileSuffix() + originalCssFile.substring(lastDotIndex) : originalCssFile + this.parameters.getCssFileSuffix();
        if (this.parameters.hasOutputDir()) {
            return org.carrot2.util.FileUtils.changeRoot(processedCssFile, this.parameters.getRootDir(), this.parameters.getOutputDir());
        }
        return processedCssFile;
    }
}

