/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.labs.smartsprites;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.Map;
import java.util.Set;
import org.carrot2.labs.smartsprites.SpriteImageDirective;
import org.carrot2.labs.smartsprites.css.CssProperty;
import org.carrot2.labs.smartsprites.css.CssSyntaxUtils;
import org.carrot2.labs.smartsprites.message.Message;
import org.carrot2.labs.smartsprites.message.MessageLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpriteLayoutProperties {
    public static final String PROPERTY_SPRITE_ALIGNMENT = "sprite-alignment";
    public static final String PROPERTY_SPRITE_MARGIN_BOTTOM = "sprite-margin-bottom";
    public static final String PROPERTY_SPRITE_MARGIN_TOP = "sprite-margin-top";
    public static final String PROPERTY_SPRITE_MARGIN_RIGHT = "sprite-margin-right";
    public static final String PROPERTY_SPRITE_MARGIN_LEFT = "sprite-margin-left";
    static final Set<String> ALLOWED_PROPERTIES = ImmutableSet.of((Object)"sprite-alignment", (Object)"sprite-margin-left", (Object)"sprite-margin-right", (Object)"sprite-margin-top", (Object)"sprite-margin-bottom");
    public final SpriteAlignment alignment;
    public final int marginLeft;
    public final int marginRight;
    public final int marginTop;
    public final int marginBottom;

    public SpriteLayoutProperties(SpriteAlignment alignment, int marginLeft, int marginRight, int marginTop, int marginBottom) {
        this.alignment = alignment;
        this.marginLeft = marginLeft;
        this.marginRight = marginRight;
        this.marginTop = marginTop;
        this.marginBottom = marginBottom;
    }

    SpriteLayoutProperties(SpriteImageDirective.SpriteImageLayout layout) {
        this(SpriteLayoutProperties.getDefaultAlignment(layout), 0, 0, 0, 0);
    }

    public static SpriteLayoutProperties parse(String directiveString, SpriteImageDirective.SpriteImageLayout spriteImageLayout, MessageLog messageCollector) {
        return SpriteLayoutProperties.parse(directiveString, spriteImageLayout, new SpriteLayoutProperties(spriteImageLayout), messageCollector);
    }

    public static SpriteLayoutProperties parse(String directiveString, SpriteImageDirective.SpriteImageLayout spriteImageLayout, SpriteLayoutProperties defaults, MessageLog messageCollector) {
        SpriteAlignment alignment;
        Map<String, CssProperty> rules = CssSyntaxUtils.propertiesAsMap(CssSyntaxUtils.extractRules(directiveString, messageCollector));
        if (CssSyntaxUtils.hasNonBlankValue(rules, PROPERTY_SPRITE_ALIGNMENT)) {
            String alignmentValue = rules.get((Object)PROPERTY_SPRITE_ALIGNMENT).value;
            try {
                alignment = SpriteLayoutProperties.correctAlignment(spriteImageLayout, SpriteAlignment.getValue(alignmentValue), messageCollector);
            }
            catch (IllegalArgumentException e) {
                messageCollector.warning(Message.MessageType.UNSUPPORTED_ALIGNMENT, alignmentValue);
                alignment = SpriteLayoutProperties.getDefaultAlignment(spriteImageLayout);
            }
        } else {
            alignment = defaults.alignment;
        }
        int marginLeft = SpriteLayoutProperties.getMargin(PROPERTY_SPRITE_MARGIN_LEFT, rules, defaults.marginLeft, messageCollector);
        int marginRight = SpriteLayoutProperties.getMargin(PROPERTY_SPRITE_MARGIN_RIGHT, rules, defaults.marginRight, messageCollector);
        int marginTop = SpriteLayoutProperties.getMargin(PROPERTY_SPRITE_MARGIN_TOP, rules, defaults.marginTop, messageCollector);
        int marginBottom = SpriteLayoutProperties.getMargin(PROPERTY_SPRITE_MARGIN_BOTTOM, rules, defaults.marginBottom, messageCollector);
        return new SpriteLayoutProperties(alignment, marginLeft, marginRight, marginTop, marginBottom);
    }

    private static SpriteAlignment correctAlignment(SpriteImageDirective.SpriteImageLayout spriteImageLayout, SpriteAlignment alignment, MessageLog messageCollector) {
        if (spriteImageLayout.equals((Object)SpriteImageDirective.SpriteImageLayout.HORIZONTAL)) {
            if (alignment.equals((Object)SpriteAlignment.LEFT) || alignment.equals((Object)SpriteAlignment.RIGHT)) {
                messageCollector.warning(Message.MessageType.ONLY_TOP_OR_BOTTOM_ALIGNMENT_ALLOWED, alignment.value);
                return SpriteAlignment.TOP;
            }
        } else if (alignment.equals((Object)SpriteAlignment.TOP) || alignment.equals((Object)SpriteAlignment.BOTTOM)) {
            messageCollector.warning(Message.MessageType.ONLY_LEFT_OR_RIGHT_ALIGNMENT_ALLOWED, alignment.value);
            return SpriteAlignment.LEFT;
        }
        return alignment;
    }

    private static SpriteAlignment getDefaultAlignment(SpriteImageDirective.SpriteImageLayout spriteImageLayout) {
        if (spriteImageLayout.equals((Object)SpriteImageDirective.SpriteImageLayout.HORIZONTAL)) {
            return SpriteAlignment.TOP;
        }
        return SpriteAlignment.LEFT;
    }

    private static int getMargin(String marginRule, Map<String, CssProperty> rules, int defaultMargin, MessageLog messageLog) {
        if (CssSyntaxUtils.hasNonBlankValue(rules, marginRule)) {
            String rawMarginValue = rules.get((Object)marginRule).value;
            String marginValue = rawMarginValue;
            if (marginValue.toLowerCase().endsWith("px")) {
                marginValue = marginValue.substring(0, marginValue.length() - 2);
            }
            try {
                int marginIntValue = Integer.parseInt(marginValue);
                if (marginIntValue < 0) {
                    messageLog.warning(Message.MessageType.IGNORING_NEGATIVE_MARGIN_VALUE, marginRule);
                    marginIntValue = 0;
                }
                return marginIntValue;
            }
            catch (NumberFormatException e) {
                messageLog.warning(Message.MessageType.CANNOT_PARSE_MARGIN_VALUE, rawMarginValue);
                return 0;
            }
        }
        return defaultMargin;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SpriteAlignment {
        LEFT,
        RIGHT,
        TOP,
        BOTTOM,
        REPEAT,
        CENTER;

        private String value = this.name().toLowerCase();

        public String toString() {
            return this.value;
        }

        public static SpriteAlignment getValue(String value) {
            return SpriteAlignment.valueOf(value.toUpperCase());
        }

        public static String valuesAsString() {
            String list = Lists.newArrayList((Object[])SpriteAlignment.values()).toString();
            return list.substring(1, list.length() - 1);
        }
    }
}

