/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.labs.smartsprites;

import java.awt.image.BufferedImage;
import org.carrot2.labs.smartsprites.SpriteDirectiveOccurrence;
import org.carrot2.labs.smartsprites.SpriteImageDirective;
import org.carrot2.labs.smartsprites.SpriteLayoutProperties;
import org.carrot2.labs.smartsprites.SpriteReferenceDirective;
import org.carrot2.labs.smartsprites.SpriteReferenceReplacement;
import org.carrot2.util.BufferedImageUtils;

public class SpriteReferenceOccurrence
extends SpriteDirectiveOccurrence {
    public final SpriteReferenceDirective spriteReferenceDirective;
    public final String imagePath;
    public final boolean important;

    public SpriteReferenceOccurrence(SpriteReferenceDirective spriteReferenceDirective, String imageFile, String cssFile, int line, boolean important) {
        super(cssFile, line);
        this.spriteReferenceDirective = spriteReferenceDirective;
        this.imagePath = imageFile;
        this.important = important;
    }

    public int getRequiredWidth(BufferedImage image, SpriteImageDirective.SpriteImageLayout layout) {
        if (SpriteLayoutProperties.SpriteAlignment.REPEAT.equals((Object)this.spriteReferenceDirective.spriteLayoutProperties.alignment) && SpriteImageDirective.SpriteImageLayout.VERTICAL.equals((Object)layout)) {
            return image.getWidth();
        }
        return image.getWidth() + this.spriteReferenceDirective.spriteLayoutProperties.marginLeft + this.spriteReferenceDirective.spriteLayoutProperties.marginRight;
    }

    public int getRequiredHeight(BufferedImage image, SpriteImageDirective.SpriteImageLayout layout) {
        if (SpriteLayoutProperties.SpriteAlignment.REPEAT.equals((Object)this.spriteReferenceDirective.spriteLayoutProperties.alignment) && SpriteImageDirective.SpriteImageLayout.HORIZONTAL.equals((Object)layout)) {
            return image.getHeight();
        }
        return image.getHeight() + this.spriteReferenceDirective.spriteLayoutProperties.marginTop + this.spriteReferenceDirective.spriteLayoutProperties.marginBottom;
    }

    public BufferedImage render(BufferedImage image, SpriteImageDirective.SpriteImageLayout layout, int dimension) {
        BufferedImage rendered;
        if (SpriteImageDirective.SpriteImageLayout.VERTICAL.equals((Object)layout)) {
            rendered = new BufferedImage(dimension, this.getRequiredHeight(image, layout), 6);
            if (SpriteLayoutProperties.SpriteAlignment.LEFT.equals((Object)this.spriteReferenceDirective.spriteLayoutProperties.alignment)) {
                BufferedImageUtils.drawImage(image, rendered, this.spriteReferenceDirective.spriteLayoutProperties.marginLeft, this.spriteReferenceDirective.spriteLayoutProperties.marginTop);
            } else if (SpriteLayoutProperties.SpriteAlignment.RIGHT.equals((Object)this.spriteReferenceDirective.spriteLayoutProperties.alignment)) {
                BufferedImageUtils.drawImage(image, rendered, dimension - this.spriteReferenceDirective.spriteLayoutProperties.marginRight - image.getWidth(), this.spriteReferenceDirective.spriteLayoutProperties.marginTop);
            } else if (SpriteLayoutProperties.SpriteAlignment.CENTER.equals((Object)this.spriteReferenceDirective.spriteLayoutProperties.alignment)) {
                BufferedImageUtils.drawImage(image, rendered, (rendered.getWidth() - image.getWidth()) / 2, this.spriteReferenceDirective.spriteLayoutProperties.marginTop);
            } else {
                for (int x = 0; x < dimension; x += image.getWidth()) {
                    BufferedImageUtils.drawImage(image, rendered, x, this.spriteReferenceDirective.spriteLayoutProperties.marginTop);
                }
            }
        } else {
            rendered = new BufferedImage(this.getRequiredWidth(image, layout), dimension, 6);
            if (SpriteLayoutProperties.SpriteAlignment.TOP.equals((Object)this.spriteReferenceDirective.spriteLayoutProperties.alignment)) {
                BufferedImageUtils.drawImage(image, rendered, this.spriteReferenceDirective.spriteLayoutProperties.marginLeft, this.spriteReferenceDirective.spriteLayoutProperties.marginTop);
            } else if (SpriteLayoutProperties.SpriteAlignment.BOTTOM.equals((Object)this.spriteReferenceDirective.spriteLayoutProperties.alignment)) {
                BufferedImageUtils.drawImage(image, rendered, this.spriteReferenceDirective.spriteLayoutProperties.marginLeft, dimension - this.spriteReferenceDirective.spriteLayoutProperties.marginBottom - image.getHeight());
            } else if (SpriteLayoutProperties.SpriteAlignment.CENTER.equals((Object)this.spriteReferenceDirective.spriteLayoutProperties.alignment)) {
                BufferedImageUtils.drawImage(image, rendered, this.spriteReferenceDirective.spriteLayoutProperties.marginLeft, (rendered.getHeight() - image.getHeight()) / 2);
            } else {
                for (int y = 0; y < dimension; y += image.getHeight()) {
                    BufferedImageUtils.drawImage(image, rendered, this.spriteReferenceDirective.spriteLayoutProperties.marginLeft, y);
                }
            }
        }
        return rendered;
    }

    public SpriteReferenceReplacement buildReplacement(SpriteImageDirective.SpriteImageLayout layout, int offset) {
        if (SpriteImageDirective.SpriteImageLayout.VERTICAL.equals((Object)layout)) {
            String horizontalPosition = SpriteLayoutProperties.SpriteAlignment.RIGHT.equals((Object)this.spriteReferenceDirective.spriteLayoutProperties.alignment) ? "right" : (SpriteLayoutProperties.SpriteAlignment.CENTER.equals((Object)this.spriteReferenceDirective.spriteLayoutProperties.alignment) ? "center" : "left");
            return new SpriteReferenceReplacement(this, offset, horizontalPosition);
        }
        String verticalPosition = SpriteLayoutProperties.SpriteAlignment.BOTTOM.equals((Object)this.spriteReferenceDirective.spriteLayoutProperties.alignment) ? "bottom" : (SpriteLayoutProperties.SpriteAlignment.CENTER.equals((Object)this.spriteReferenceDirective.spriteLayoutProperties.alignment) ? "center" : "top");
        return new SpriteReferenceReplacement(this, verticalPosition, offset);
    }
}

