/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.labs.smartsprites.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.carrot2.labs.smartsprites.message.Message;
import org.carrot2.labs.smartsprites.message.MessageLog;
import org.carrot2.labs.smartsprites.resource.ResourceHandler;
import org.carrot2.util.FileUtils;

public class FileSystemResourceHandler
implements ResourceHandler {
    private final MessageLog messageLog;
    private final String documentRootDir;
    private final String charset;

    public FileSystemResourceHandler(String documentRootDirPath, String charset, MessageLog messageLog) {
        this.documentRootDir = documentRootDirPath;
        this.messageLog = messageLog;
        this.charset = charset;
        if (!Charset.isSupported(charset)) {
            messageLog.error(Message.MessageType.GENERIC, "Charset '" + charset + "' is not supported.");
        }
    }

    public InputStream getResourceAsInputStream(String path) throws IOException {
        return new FileInputStream(FileUtils.getCanonicalOrAbsoluteFile(path));
    }

    public Reader getResourceAsReader(String path) throws IOException {
        try {
            return new InputStreamReader(this.getResourceAsInputStream(path), this.charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public OutputStream getResourceAsOutputStream(String path) throws IOException {
        File parentFile = new File(path).getParentFile();
        if (!parentFile.exists() && !parentFile.mkdirs()) {
            this.messageLog.warning(Message.MessageType.CANNOT_CREATE_DIRECTORIES, parentFile.getPath());
        }
        return new FileOutputStream(FileUtils.getCanonicalOrAbsoluteFile(path));
    }

    public Writer getResourceAsWriter(String path) throws IOException {
        try {
            return new OutputStreamWriter(this.getResourceAsOutputStream(path), this.charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String getResourcePath(String baseFile, String filePath) {
        if (filePath.startsWith("/")) {
            if (StringUtils.isNotBlank((CharSequence)this.documentRootDir)) {
                return FilenameUtils.concat((String)this.documentRootDir, (String)filePath.substring(1));
            }
            this.messageLog.warning(Message.MessageType.ABSOLUTE_PATH_AND_NO_DOCUMENT_ROOT, filePath);
            return "";
        }
        return FilenameUtils.concat((String)FilenameUtils.getFullPath((String)baseFile), (String)filePath);
    }
}

