/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util;

import com.google.common.collect.Sets;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.CompositeContext;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.HashSet;

public class BufferedImageUtils {
    public static boolean hasPartialTransparency(BufferedImage image) {
        int[] pixels;
        WritableRaster alphaRaster = image.getAlphaRaster();
        if (image.getTransparency() != 3 || alphaRaster == null) {
            return false;
        }
        for (int i : pixels = alphaRaster.getPixels(0, 0, alphaRaster.getWidth(), alphaRaster.getHeight(), (int[])null)) {
            if (i == 0 || i == 255) continue;
            return true;
        }
        return false;
    }

    public static boolean hasTransparency(BufferedImage image) {
        int[] pixels;
        WritableRaster alphaRaster = image.getAlphaRaster();
        if (image.getTransparency() != 3 || alphaRaster == null) {
            return false;
        }
        for (int i : pixels = alphaRaster.getPixels(0, 0, alphaRaster.getWidth(), alphaRaster.getHeight(), (int[])null)) {
            if (i == 255) continue;
            return true;
        }
        return false;
    }

    public static int countDistictColors(BufferedImage image) {
        return BufferedImageUtils.getDistictColors(image).length;
    }

    public static int[] getDistictColors(BufferedImage image) {
        return BufferedImageUtils.getDistictColors(image, 0);
    }

    public static int[] getDistictColors(BufferedImage image, int padding) {
        int width = image.getWidth();
        int height = image.getHeight();
        HashSet colors = Sets.newHashSet();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int pixel = image.getRGB(x, y);
                if ((pixel & 0xFF000000) == 0) continue;
                colors.add(pixel & 0xFFFFFF);
            }
        }
        int[] colorMap = new int[colors.size() + padding];
        int index = padding;
        for (Integer color : colors) {
            colorMap[index++] = color;
        }
        return colorMap;
    }

    public static int[][] getRgb(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        int[][] rgb = new int[width][height];
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                rgb[x][y] = image.getRGB(x, y);
            }
        }
        return rgb;
    }

    public static BufferedImage matte(BufferedImage source, Color matteColor) {
        int width = source.getWidth();
        int height = source.getHeight();
        BufferedImage sourceConverted = new BufferedImage(width, height, 6);
        sourceConverted.getGraphics().drawImage(source, 0, 0, null);
        BufferedImage matted = new BufferedImage(width, height, 6);
        BufferedImage matte = new BufferedImage(width, height, 6);
        int matteRgb = matteColor.getRGB();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                matte.setRGB(x, y, matteRgb);
            }
        }
        CompositeContext context = AlphaComposite.DstOver.createContext(matte.getColorModel(), sourceConverted.getColorModel(), null);
        context.compose(matte.getRaster(), sourceConverted.getRaster(), matted.getRaster());
        return matted;
    }

    public static void drawImage(BufferedImage image, BufferedImage canvas, int x, int y) {
        int[] imgRGB = image.getRGB(0, 0, image.getWidth(), image.getHeight(), null, 0, image.getWidth());
        canvas.setRGB(x, y, image.getWidth(), image.getHeight(), imgRGB, 0, image.getWidth());
    }

    private BufferedImageUtils() {
    }
}

