/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.labs.smartsprites;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.carrot2.labs.smartsprites.message.Message;
import org.carrot2.labs.smartsprites.message.MessageLog;
import org.carrot2.util.FileUtils;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SmartSpritesParameters {
    @Option(name="--root-dir-path", required=false, metaVar="DIR")
    private String rootDir;
    @Argument(metaVar="CSS-FILES")
    @Option(name="--css-files", required=false, metaVar="FILES")
    private List<String> cssFiles;
    @Option(name="--output-dir-path", metaVar="DIR")
    private String outputDir;
    @Option(name="--document-root-dir-path", metaVar="DIR")
    private String documentRootDir;
    @Option(name="--log-level")
    private Message.MessageLevel logLevel;
    @Option(name="--css-file-encoding")
    private String cssFileEncoding;
    @Option(name="--css-file-suffix")
    private String cssFileSuffix;
    @Option(name="--sprite-png-depth")
    private PngDepth spritePngDepth;
    @Option(name="--sprite-png-ie6")
    private boolean spritePngIe6;
    public static final String DEFAULT_CSS_FILE_SUFFIX = "-sprite";
    public static final PngDepth DEFAULT_SPRITE_PNG_DEPTH = PngDepth.AUTO;
    public static final boolean DEFAULT_SPRITE_PNG_IE6 = false;
    public static final String DEFAULT_CSS_FILE_ENCODING = "UTF-8";
    public static final Message.MessageLevel DEFAULT_LOGGING_LEVEL = Message.MessageLevel.INFO;

    public SmartSpritesParameters() {
        this(null);
    }

    public SmartSpritesParameters(String rootDir) {
        this(rootDir, null, null, null, Message.MessageLevel.INFO, DEFAULT_CSS_FILE_SUFFIX, DEFAULT_SPRITE_PNG_DEPTH, false, DEFAULT_CSS_FILE_ENCODING);
    }

    public SmartSpritesParameters(String rootDir, List<String> cssFiles, String outputDir, String documentRootDir, Message.MessageLevel logLevel, String cssFileSuffix, PngDepth spritePngDepth, boolean spritePngIe6, String cssEncoding) {
        this.rootDir = rootDir;
        this.cssFiles = cssFiles;
        this.outputDir = outputDir;
        this.documentRootDir = documentRootDir;
        this.logLevel = logLevel;
        this.cssFileEncoding = cssEncoding;
        this.cssFileSuffix = this.getCssFileSuffix(cssFileSuffix);
        this.spritePngDepth = spritePngDepth;
        this.spritePngIe6 = spritePngIe6;
    }

    public boolean validate(MessageLog log) {
        File documentRootDir;
        File rootDir;
        boolean valid = true;
        if (!this.hasRootDir() && !this.hasCssFiles()) {
            log.error(Message.MessageType.EITHER_ROOT_DIR_OR_CSS_FILES_IS_REQIRED, new Object[0]);
            return false;
        }
        if (!this.hasOutputDir() && this.hasRootDir() && this.hasCssFiles()) {
            log.error(Message.MessageType.ROOT_DIR_AND_CSS_FILES_CANNOT_BE_BOTH_SPECIFIED_UNLESS_WITH_OUTPUT_DIR, new Object[0]);
            return false;
        }
        if (!(!this.hasRootDir() || (rootDir = FileUtils.getCanonicalOrAbsoluteFile(this.rootDir)).exists() && rootDir.isDirectory())) {
            log.error(Message.MessageType.ROOT_DIR_DOES_NOT_EXIST_OR_IS_NOT_DIRECTORY, this.rootDir);
            valid = false;
        }
        if (this.hasOutputDir()) {
            if (!this.hasRootDir()) {
                log.error(Message.MessageType.ROOT_DIR_IS_REQIRED_FOR_OUTPUT_DIR, new Object[0]);
                return false;
            }
            File outputDir = FileUtils.getCanonicalOrAbsoluteFile(this.outputDir);
            if (outputDir.exists() && !outputDir.isDirectory()) {
                log.error(Message.MessageType.OUTPUT_DIR_IS_NOT_DIRECTORY, this.outputDir);
                valid = false;
            }
        }
        if (!this.hasOutputDir() && StringUtils.isBlank((CharSequence)this.cssFileSuffix)) {
            log.error(Message.MessageType.CSS_FILE_SUFFIX_IS_REQUIRED_IF_NO_OUTPUT_DIR, new Object[0]);
            valid = false;
        }
        if (!(!this.hasDocumentRootDir() || (documentRootDir = FileUtils.getCanonicalOrAbsoluteFile(this.documentRootDir)).exists() && documentRootDir.isDirectory())) {
            log.error(Message.MessageType.DOCUMENT_ROOT_DIR_DOES_NOT_EXIST_OR_IS_NOT_DIRECTORY, this.documentRootDir);
            valid = false;
        }
        return valid;
    }

    private String getCssFileSuffix(String suffix) {
        if (suffix == null) {
            if (!this.hasOutputDir()) {
                return DEFAULT_CSS_FILE_SUFFIX;
            }
            return "";
        }
        return suffix;
    }

    public String getRootDir() {
        return this.rootDir;
    }

    public File getRootDirFile() throws IOException {
        return this.rootDir.startsWith("..") ? new File(this.rootDir).getCanonicalFile() : new File(this.rootDir);
    }

    public boolean hasRootDir() {
        return StringUtils.isNotBlank((CharSequence)this.rootDir);
    }

    public List<String> getCssFiles() {
        return this.cssFiles;
    }

    public boolean hasCssFiles() {
        return this.cssFiles != null && !this.cssFiles.isEmpty();
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public boolean hasOutputDir() {
        return StringUtils.isNotBlank((CharSequence)this.outputDir);
    }

    public String getDocumentRootDir() {
        return this.documentRootDir;
    }

    public boolean hasDocumentRootDir() {
        return StringUtils.isNotBlank((CharSequence)this.documentRootDir);
    }

    public Message.MessageLevel getLogLevel() {
        return this.logLevel;
    }

    public String getCssFileSuffix() {
        return this.cssFileSuffix;
    }

    public PngDepth getSpritePngDepth() {
        return this.spritePngDepth;
    }

    public boolean isSpritePngIe6() {
        return this.spritePngIe6;
    }

    public String getCssFileEncoding() {
        return this.cssFileEncoding;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PngDepth {
        AUTO,
        INDEXED,
        DIRECT;

    }
}

