/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.labs.smartsprites;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.awt.Color;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.carrot2.labs.smartsprites.SpriteLayoutProperties;
import org.carrot2.labs.smartsprites.css.CssProperty;
import org.carrot2.labs.smartsprites.css.CssSyntaxUtils;
import org.carrot2.labs.smartsprites.message.Message;
import org.carrot2.labs.smartsprites.message.MessageLog;
import org.carrot2.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpriteImageDirective {
    public static final String PROPERTY_SPRITE_ID = "sprite";
    public static final String PROPERTY_SPRITE_IMAGE_LAYOUT = "sprite-layout";
    public static final String PROPERTY_SPRITE_IMAGE_URL = "sprite-image";
    public static final String PROPERTY_SPRITE_IMAGE_UID_SUFFIX = "sprite-image-uid";
    public static final String PROPERTY_SPRITE_MATTE_COLOR = "sprite-matte-color";
    public static final String PROPERTY_SPRITE_IE6_MODE = "sprite-ie6-mode";
    public static final String PROPERTY_SPRITE_SCALE = "sprite-scale";
    private static final Set<String> ALLOWED_PROPERTIES = ImmutableSet.of((Object)"sprite", (Object)"sprite-layout", (Object)"sprite-image", (Object)"sprite-matte-color", (Object)"sprite-ie6-mode", (Object)"sprite-scale", (Object[])new String[]{"sprite-image-uid"});
    public final String spriteId;
    public final String imagePath;
    public final SpriteUidType uidType;
    public final SpriteImageLayout layout;
    public final SpriteImageFormat format;
    public final Ie6Mode ie6Mode;
    public final Color matteColor;
    public final float scaleRatio;
    public final SpriteLayoutProperties spriteLayoutProperties;
    private static final Pattern IMAGE_PATH_PATTERN = Pattern.compile("([^${}]*|\\$\\{[^}]*\\})*");
    private static final Pattern IMAGE_PATH_VARIABLE_PATTERN = Pattern.compile("\\$\\{([a-z]*)\\}");
    private static final Set<String> ALLOWED_VARIABLES = ImmutableSet.of((Object)"sprite", (Object)SpriteUidType.DATE.toString(), (Object)SpriteUidType.MD5.toString());

    public SpriteImageDirective(String id, String imageUrl, SpriteImageLayout layout, SpriteImageFormat format, Ie6Mode ie6Mode, Color matteColor, SpriteUidType uidType, float scale) {
        this(id, imageUrl, layout, format, ie6Mode, matteColor, uidType, scale, new SpriteLayoutProperties(layout));
    }

    public SpriteImageDirective(String id, String imageUrl, SpriteImageLayout layout, SpriteImageFormat format, Ie6Mode ie6Mode, Color matteColor, SpriteUidType uidType, float scale, SpriteLayoutProperties spriteLayoutProperties) {
        this.spriteId = id;
        this.imagePath = imageUrl;
        this.layout = layout;
        this.format = format;
        this.ie6Mode = ie6Mode;
        this.matteColor = matteColor;
        this.uidType = uidType;
        this.scaleRatio = scale;
        this.spriteLayoutProperties = spriteLayoutProperties;
    }

    public static SpriteImageDirective parse(String directiveString, MessageLog messageCollector) {
        SpriteImageFormat format;
        String imagePath;
        Map<String, CssProperty> rules = CssSyntaxUtils.propertiesAsMap(CssSyntaxUtils.extractRules(directiveString, messageCollector));
        LinkedHashSet properties = Sets.newLinkedHashSet(rules.keySet());
        properties.removeAll(ALLOWED_PROPERTIES);
        properties.removeAll(SpriteLayoutProperties.ALLOWED_PROPERTIES);
        if (!properties.isEmpty()) {
            messageCollector.warning(Message.MessageType.UNSUPPORTED_PROPERTIES_FOUND, CollectionUtils.toString(properties));
        }
        if (!CssSyntaxUtils.hasNonBlankValue(rules, PROPERTY_SPRITE_ID)) {
            messageCollector.warning(Message.MessageType.SPRITE_ID_NOT_FOUND, new Object[0]);
            return null;
        }
        if (!CssSyntaxUtils.hasNonBlankValue(rules, PROPERTY_SPRITE_IMAGE_URL)) {
            messageCollector.warning(Message.MessageType.SPRITE_IMAGE_URL_NOT_FOUND, new Object[0]);
            return null;
        }
        String id = rules.get((Object)PROPERTY_SPRITE_ID).value;
        SpriteUidType uidGenerator = SpriteImageDirective.valueOf(CssSyntaxUtils.getValue(rules, PROPERTY_SPRITE_IMAGE_UID_SUFFIX), SpriteUidType.class, SpriteUidType.NONE, messageCollector, Message.MessageType.UNSUPPORTED_UID_TYPE);
        if (uidGenerator != SpriteUidType.NONE) {
            messageCollector.deprecation(Message.MessageType.DEPRECATED_SPRITE_IMAGE_UID, uidGenerator.toString());
        }
        if (IMAGE_PATH_PATTERN.matcher(imagePath = CssSyntaxUtils.unpackUrl(rules.get((Object)PROPERTY_SPRITE_IMAGE_URL).value)).matches()) {
            Matcher variableMatcher = IMAGE_PATH_VARIABLE_PATTERN.matcher(imagePath);
            while (variableMatcher.find()) {
                if (variableMatcher.groupCount() != 1 || ALLOWED_VARIABLES.contains(variableMatcher.group(1))) continue;
                messageCollector.warning(Message.MessageType.UNSUPPORTED_VARIABLE_IN_SPRITE_IMAGE_PATH, variableMatcher.group(1));
            }
        } else {
            messageCollector.warning(Message.MessageType.MALFORMED_SPRITE_IMAGE_PATH, imagePath);
        }
        SpriteImageLayout layout = SpriteImageDirective.valueOf(CssSyntaxUtils.getValue(rules, PROPERTY_SPRITE_IMAGE_LAYOUT), SpriteImageLayout.class, SpriteImageLayout.VERTICAL, messageCollector, Message.MessageType.UNSUPPORTED_LAYOUT);
        int lastDotIndex = imagePath.lastIndexOf(46);
        if (lastDotIndex < 0 || lastDotIndex == imagePath.length() - 1) {
            messageCollector.warning(Message.MessageType.CANNOT_DETERMINE_IMAGE_FORMAT, imagePath);
            format = SpriteImageFormat.PNG;
        } else {
            int questionMarkIndex = imagePath.indexOf(63, lastDotIndex);
            String formatValue = questionMarkIndex >= 0 ? imagePath.substring(lastDotIndex + 1, questionMarkIndex) : imagePath.substring(lastDotIndex + 1);
            try {
                format = SpriteImageFormat.getValue(formatValue);
            }
            catch (IllegalArgumentException e) {
                messageCollector.warning(Message.MessageType.UNSUPPORTED_SPRITE_IMAGE_FORMAT, formatValue);
                format = SpriteImageFormat.PNG;
            }
        }
        String ie6ModeString = CssSyntaxUtils.getValue(rules, PROPERTY_SPRITE_IE6_MODE);
        Ie6Mode ie6Mode = SpriteImageDirective.valueOf(ie6ModeString, Ie6Mode.class, Ie6Mode.AUTO, messageCollector, Message.MessageType.UNSUPPORTED_IE6_MODE);
        if (StringUtils.isNotBlank((CharSequence)ie6ModeString) && format != SpriteImageFormat.PNG) {
            messageCollector.notice(Message.MessageType.IGNORING_IE6_MODE, format.name());
        }
        Color matteColor = CssSyntaxUtils.hasNonBlankValue(rules, PROPERTY_SPRITE_MATTE_COLOR) ? CssSyntaxUtils.parseColor(rules.get((Object)PROPERTY_SPRITE_MATTE_COLOR).value, messageCollector, null) : null;
        float scale = CssSyntaxUtils.hasNonBlankValue(rules, PROPERTY_SPRITE_SCALE) ? Float.parseFloat(rules.get((Object)PROPERTY_SPRITE_SCALE).value) : 1.0f;
        return new SpriteImageDirective(id, imagePath, layout, format, ie6Mode, matteColor, uidGenerator, scale, SpriteLayoutProperties.parse(directiveString, layout, messageCollector));
    }

    private static <T extends Enum<T>> T valueOf(String stringValue, Class<T> enumClass, T defaultValue, MessageLog messageCollector, Message.MessageType messageType) {
        if (StringUtils.isNotBlank((CharSequence)stringValue)) {
            try {
                return Enum.valueOf(enumClass, stringValue.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                messageCollector.warning(messageType, stringValue);
                return defaultValue;
            }
        }
        return defaultValue;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Ie6Mode {
        NONE,
        AUTO;

        private String value = this.name().toLowerCase();

        public String toString() {
            return this.value;
        }

        public static String valuesAsString() {
            String list = Lists.newArrayList((Object[])Ie6Mode.values()).toString();
            return list.substring(1, list.length() - 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SpriteImageFormat {
        PNG,
        GIF,
        JPG;

        private String value = this.name().toLowerCase();

        public String toString() {
            return this.value;
        }

        public static SpriteImageFormat getValue(String value) {
            return SpriteImageFormat.valueOf(value.toUpperCase());
        }

        public static String valuesAsString() {
            String list = Lists.newArrayList((Object[])SpriteImageFormat.values()).toString();
            return list.substring(1, list.length() - 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SpriteUidType {
        NONE,
        DATE,
        MD5;

        private String value = this.name().toLowerCase();
        public final Pattern pattern = Pattern.compile("${" + this.value + "}", 16);

        public String toString() {
            return this.value;
        }

        public static String valuesAsString() {
            String list = Lists.newArrayList((Object[])SpriteUidType.values()).toString();
            return list.substring(1, list.length() - 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SpriteImageLayout {
        VERTICAL,
        HORIZONTAL;

        private String value = this.name().toLowerCase();

        public String toString() {
            return this.value;
        }

        public static String valuesAsString() {
            String list = Lists.newArrayList((Object[])SpriteImageLayout.values()).toString();
            return list.substring(1, list.length() - 1);
        }
    }
}

