/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.labs.smartsprites.css;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.carrot2.labs.smartsprites.css.CssProperty;
import org.carrot2.labs.smartsprites.message.Message;
import org.carrot2.labs.smartsprites.message.MessageLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CssSyntaxUtils {
    private static final Pattern URL_PATTERN = Pattern.compile("[uU][rR][lL]\\((['\"]?)([^'\"]*)\\1\\)");
    private static final Pattern COLOR_PATTERN = Pattern.compile("#([0-9a-f]{6})");
    private static final Pattern IMPORTANT_PATTERN = Pattern.compile("!\\s*important");

    public static List<CssProperty> extractProperties(String text) {
        return CssSyntaxUtils.extractRules(text, null);
    }

    public static List<CssProperty> extractRules(String text, MessageLog messageLog) {
        String[] chunks;
        ArrayList rules = Lists.newArrayList();
        for (String chunk : chunks = text.split(";")) {
            String[] parts = chunk.split(":", 2);
            if (parts.length == 2) {
                String value = parts[1].trim();
                Matcher matcher = IMPORTANT_PATTERN.matcher(value);
                boolean important = false;
                if (matcher.find()) {
                    important = true;
                    value = matcher.replaceAll("");
                }
                rules.add(new CssProperty(parts[0].trim().toLowerCase(), value.trim(), important));
                continue;
            }
            if (messageLog == null) continue;
            messageLog.warning(Message.MessageType.MALFORMED_CSS_RULE, chunk.trim());
        }
        return rules;
    }

    public static Map<String, CssProperty> propertiesAsMap(Collection<CssProperty> rules) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (CssProperty cssProperty : rules) {
            result.put(cssProperty.rule, cssProperty);
        }
        return result;
    }

    public static String getValue(Map<String, CssProperty> rules, String property) {
        CssProperty cssProperty = rules.get(property);
        if (cssProperty != null) {
            return cssProperty.value;
        }
        return null;
    }

    public static boolean hasNonBlankValue(Map<String, CssProperty> properties, String propertyName) {
        return properties.containsKey(propertyName) && !StringUtils.isBlank((CharSequence)properties.get((Object)propertyName).value);
    }

    public static String unpackUrl(String urlValue) {
        return CssSyntaxUtils.unpackUrl(urlValue, null);
    }

    public static String unpackUrl(String urlValue, MessageLog messageLog) {
        Matcher matcher = URL_PATTERN.matcher(urlValue);
        if (!matcher.matches()) {
            if (messageLog != null) {
                messageLog.warning(Message.MessageType.MALFORMED_URL, urlValue);
            }
            return null;
        }
        String url = matcher.group(2);
        return url != null ? url.trim() : url;
    }

    public static Color parseColor(String colorValue, MessageLog messageLog, Color defaultColor) {
        Matcher matcher = COLOR_PATTERN.matcher(colorValue);
        if (!matcher.matches()) {
            if (messageLog != null) {
                messageLog.warning(Message.MessageType.MALFORMED_COLOR, colorValue);
            }
            return defaultColor;
        }
        return new Color(Integer.parseInt(matcher.group(1), 16));
    }
}

