/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cache;

import org.atmosphere.cache.AbstractBroadcasterCache;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceImpl;

public class HeaderBroadcasterCache
extends AbstractBroadcasterCache {
    @Override
    public void cache(String id, AtmosphereResource ar, AbstractBroadcasterCache.CachedMessage cm) {
        long time = cm.next() == null ? cm.currentTime() : cm.next().currentTime();
        AtmosphereResourceImpl r = (AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(ar);
        if (r != null && r.isInScope() && !r.getResponse().isCommitted()) {
            r.getResponse().addHeader("X-Cache-Date", String.valueOf(time));
        }
    }

    @Override
    public AbstractBroadcasterCache.CachedMessage retrieveLastMessage(String id, AtmosphereResource ar) {
        AtmosphereResourceImpl r = (AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(ar);
        if (!r.isInScope()) {
            return null;
        }
        AtmosphereRequest request = r.getRequest();
        return this.retrieveUsingHeader(request.getHeader("X-Cache-Date"));
    }

    public AbstractBroadcasterCache.CachedMessage retrieveUsingHeader(String dateString) {
        if (dateString == null) {
            return null;
        }
        long currentTime = 0L;
        try {
            currentTime = Long.valueOf(dateString);
        }
        catch (NumberFormatException ex) {
            logger.trace("", (Throwable)ex);
            return null;
        }
        AbstractBroadcasterCache.CachedMessage prev = null;
        for (AbstractBroadcasterCache.CachedMessage cm : this.queue) {
            if (cm.currentTime() > currentTime) {
                return prev;
            }
            prev = cm;
        }
        return prev;
    }
}

