/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.DatastoreApiHelper;
import com.google.appengine.api.datastore.Key;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.List;

class KeyTranslator {
    public static Key createFromPb(OnestoreEntity.Reference reference) {
        String appId = reference.getApp();
        Key parentKey = null;
        OnestoreEntity.Path path = reference.getPath();
        List<OnestoreEntity.Path.Element> elements = path.elements();
        if (elements.isEmpty()) {
            throw new IllegalArgumentException("Invalid Key PB: no elements.");
        }
        for (OnestoreEntity.Path.Element e : elements) {
            String kind = e.getType();
            if (e.hasName() && e.hasId()) {
                throw new IllegalArgumentException("Invalid Key PB: both id and name are set.");
            }
            if (e.hasName()) {
                parentKey = new Key(kind, parentKey, 0L, e.getName(), appId);
                continue;
            }
            if (e.hasId()) {
                parentKey = new Key(kind, parentKey, e.getId(), null, appId);
                continue;
            }
            parentKey = new Key(kind, parentKey, 0L, null, appId);
        }
        return parentKey;
    }

    public static OnestoreEntity.Reference convertToPb(Key key) {
        OnestoreEntity.Reference reference = new OnestoreEntity.Reference();
        String appId = key.getAppId();
        if (appId == null) {
            appId = DatastoreApiHelper.getCurrentAppId();
        }
        reference.setApp(appId);
        OnestoreEntity.Path path = reference.getMutablePath();
        while (key != null) {
            OnestoreEntity.Path.Element pathElement = new OnestoreEntity.Path.Element();
            pathElement.setType(key.getKind());
            if (key.getName() != null) {
                pathElement.setName(key.getName());
            } else if (key.getId() != 0L) {
                pathElement.setId(key.getId());
            }
            path.insertElement(0, pathElement);
            key = key.getParent();
        }
        return reference;
    }

    public static void updateKey(OnestoreEntity.Reference reference, Key key) {
        if (key.getName() == null) {
            OnestoreEntity.Path path = reference.getPath();
            key.setId(path.getElement(path.elementSize() - 1).getId());
        }
        key.setAppId(reference.getApp());
    }

    private KeyTranslator() {
    }
}

