/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.images;

import com.google.appengine.api.images.Composite;
import com.google.appengine.api.images.Image;
import com.google.appengine.api.images.ImagesService;
import com.google.appengine.api.images.ImagesServiceFactory;
import com.google.appengine.api.images.ImagesServiceFailureException;
import com.google.appengine.api.images.ImagesServicePb;
import com.google.appengine.api.images.Transform;
import com.google.apphosting.api.ApiProxy;
import java.util.Collection;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImagesServiceImpl
implements ImagesService {
    ImagesServiceImpl() {
    }

    @Override
    public Image applyTransform(Transform transform, Image image) {
        return this.applyTransform(transform, image, ImagesService.OutputEncoding.PNG);
    }

    @Override
    public Image applyTransform(Transform transform, Image image, ImagesService.OutputEncoding encoding) {
        ImagesServicePb.OutputSettings.MIME_TYPE mimeType;
        ImagesServicePb.ImagesTransformRequest request = new ImagesServicePb.ImagesTransformRequest();
        ImagesServicePb.ImagesTransformResponse response = new ImagesServicePb.ImagesTransformResponse();
        request.setImage(new ImagesServicePb.ImageData().setContentAsBytes(image.getImageData()));
        switch (encoding) {
            case PNG: {
                mimeType = ImagesServicePb.OutputSettings.MIME_TYPE.PNG;
                break;
            }
            case JPEG: {
                mimeType = ImagesServicePb.OutputSettings.MIME_TYPE.JPEG;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid output encoding requested");
            }
        }
        request.getMutableOutput().setMimeType(mimeType);
        transform.apply(request);
        if (request.transformSize() > 10) {
            throw new IllegalArgumentException("A maximum of 10 basic transforms can be requested in a single transform request");
        }
        try {
            byte[] responseBytes = ApiProxy.makeSyncCall("images", "Transform", request.toByteArray());
            response.mergeFrom(responseBytes);
        }
        catch (ApiProxy.ApplicationException ex) {
            ImagesServicePb.ImagesServiceError.ErrorCode code = ImagesServicePb.ImagesServiceError.ErrorCode.valueOf(ex.getApplicationError());
            if (code != null && code != ImagesServicePb.ImagesServiceError.ErrorCode.UNSPECIFIED_ERROR) {
                throw new IllegalArgumentException(ex.getErrorDetail());
            }
            throw new ImagesServiceFailureException(ex.getErrorDetail());
        }
        image.setImageData(response.getMutableImage().getContentAsBytes());
        return image;
    }

    @Override
    public Image composite(Collection<Composite> composites, int width, int height, long color) {
        return this.composite(composites, width, height, color, ImagesService.OutputEncoding.PNG);
    }

    @Override
    public Image composite(Collection<Composite> composites, int width, int height, long color, ImagesService.OutputEncoding encoding) {
        ImagesServicePb.OutputSettings.MIME_TYPE mimeType;
        ImagesServicePb.ImagesCompositeRequest request = new ImagesServicePb.ImagesCompositeRequest();
        ImagesServicePb.ImagesCompositeResponse response = new ImagesServicePb.ImagesCompositeResponse();
        if (composites.size() > 16) {
            throw new IllegalArgumentException("A maximum of 16 composites can be applied in a single request");
        }
        if (width > 4000 || width <= 0 || height > 4000 || height <= 0) {
            throw new IllegalArgumentException("Width and height must <= 4000 and > 0");
        }
        if (color > 0xFFFFFFFFL || color < 0L) {
            throw new IllegalArgumentException("Color must be in the range [0, 0xffffffff]");
        }
        if (color >= Integer.MIN_VALUE) {
            color -= 0x100000000L;
        }
        int fixedColor = (int)color;
        request.getCanvas().setWidth(width);
        request.getCanvas().setHeight(height);
        request.getCanvas().setColor(fixedColor);
        switch (encoding) {
            case PNG: {
                mimeType = ImagesServicePb.OutputSettings.MIME_TYPE.PNG;
                break;
            }
            case JPEG: {
                mimeType = ImagesServicePb.OutputSettings.MIME_TYPE.JPEG;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid output encoding requested");
            }
        }
        request.getCanvas().getOutput().setMimeType(mimeType);
        HashMap<Image, Integer> imageIdMap = new HashMap<Image, Integer>();
        for (Composite composite : composites) {
            composite.apply(request, imageIdMap);
        }
        try {
            byte[] responseBytes = ApiProxy.makeSyncCall("images", "Composite", request.toByteArray());
            response.mergeFrom(responseBytes);
        }
        catch (ApiProxy.ApplicationException ex) {
            ImagesServicePb.ImagesServiceError.ErrorCode code = ImagesServicePb.ImagesServiceError.ErrorCode.valueOf(ex.getApplicationError());
            if (code != null && code != ImagesServicePb.ImagesServiceError.ErrorCode.UNSPECIFIED_ERROR) {
                throw new IllegalArgumentException(ex.getErrorDetail());
            }
            throw new ImagesServiceFailureException(ex.getErrorDetail());
        }
        return ImagesServiceFactory.makeImage(response.getMutableImage().getContentAsBytes());
    }

    @Override
    public int[][] histogram(Image image) {
        int i;
        ImagesServicePb.ImagesHistogramRequest request = new ImagesServicePb.ImagesHistogramRequest();
        ImagesServicePb.ImagesHistogramResponse response = new ImagesServicePb.ImagesHistogramResponse();
        request.setImage(new ImagesServicePb.ImageData().setContentAsBytes(image.getImageData()));
        try {
            byte[] responseBytes = ApiProxy.makeSyncCall("images", "Histogram", request.toByteArray());
            response.mergeFrom(responseBytes);
        }
        catch (ApiProxy.ApplicationException ex) {
            ImagesServicePb.ImagesServiceError.ErrorCode code = ImagesServicePb.ImagesServiceError.ErrorCode.valueOf(ex.getApplicationError());
            if (code != null && code != ImagesServicePb.ImagesServiceError.ErrorCode.UNSPECIFIED_ERROR) {
                throw new IllegalArgumentException(ex.getErrorDetail());
            }
            throw new ImagesServiceFailureException(ex.getErrorDetail());
        }
        ImagesServicePb.ImagesHistogram histogram = response.getHistogram();
        int[][] result = new int[3][];
        for (i = 0; i < 3; ++i) {
            result[i] = new int[256];
        }
        for (i = 0; i < 256; ++i) {
            result[0][i] = histogram.getRed(i);
            result[1][i] = histogram.getGreen(i);
            result[2][i] = histogram.getBlue(i);
        }
        return result;
    }
}

