/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.memcache;

import com.google.appengine.api.memcache.InvalidValueException;
import com.google.appengine.api.memcache.MemcacheServiceException;
import com.google.appengine.repackaged.com.google.common.util.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import java.util.logging.Logger;

class MemcacheSerialization {
    private static final String ASCII_CHARSET = "US-ASCII";
    private static final String UTF8_CHARSET = "UTF-8";
    private static final byte FALSE_VALUE = 48;
    private static final byte TRUE_VALUE = 49;
    private static final String MYCLASSNAME = MemcacheSerialization.class.getName();
    private static final MessageDigest SHA1;

    private MemcacheSerialization() {
    }

    public static Object deserialize(byte[] value, int flags) throws ClassNotFoundException, IOException {
        Flag flagval = Flag.fromInt(flags);
        switch (flagval) {
            case BYTES: {
                return value;
            }
            case BOOLEAN: {
                if (value.length != 1) {
                    throw new InvalidValueException("Cannot deserialize Boolean: bad length", null);
                }
                switch (value[0]) {
                    case 49: {
                        return Boolean.TRUE;
                    }
                    case 48: {
                        return Boolean.FALSE;
                    }
                }
                throw new InvalidValueException("Cannot deserialize Boolean: bad contents", null);
            }
            case BYTE: 
            case SHORT: 
            case INTEGER: 
            case LONG: {
                long val = Long.parseLong(new String(value, ASCII_CHARSET));
                switch (flagval) {
                    case BYTE: {
                        return (byte)val;
                    }
                    case SHORT: {
                        return (short)val;
                    }
                    case INTEGER: {
                        return (int)val;
                    }
                    case LONG: {
                        return val;
                    }
                }
                throw new InvalidValueException("Cannot deserialize number: bad contents", null);
            }
            case UTF8: {
                return new String(value, UTF8_CHARSET);
            }
            case OBJECT: {
                if (value.length == 0) {
                    return null;
                }
                ByteArrayInputStream baos = new ByteArrayInputStream(value);
                ObjectInputStream objIn = new ObjectInputStream(baos);
                Object response = objIn.readObject();
                objIn.close();
                return response;
            }
        }
        assert (false);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] makePbKey(Object key) throws IOException {
        byte[] sha1hash;
        if (key == null) {
            return new byte[0];
        }
        if (key instanceof String && ((String)key).length() < 250) {
            return ("\"" + key + "\"").getBytes(UTF8_CHARSET);
        }
        if (key instanceof Long || key instanceof Integer || key instanceof Short || key instanceof Byte) {
            return (key.getClass().getName() + ":" + key).getBytes(UTF8_CHARSET);
        }
        if (key instanceof Boolean) {
            return ((Boolean)key != false ? "true" : "false").getBytes(UTF8_CHARSET);
        }
        ValueAndFlags vaf = MemcacheSerialization.serialize(key);
        MessageDigest messageDigest = SHA1;
        synchronized (messageDigest) {
            SHA1.update(vaf.value);
            sha1hash = SHA1.digest();
        }
        return Base64.encode(sha1hash).getBytes(UTF8_CHARSET);
    }

    public static ValueAndFlags serialize(Object value) throws IOException {
        Flag flags;
        byte[] bytes;
        if (value == null) {
            bytes = new byte[]{};
            flags = Flag.OBJECT;
        } else if (value instanceof byte[]) {
            flags = Flag.BYTES;
            bytes = (byte[])value;
        } else if (value instanceof Boolean) {
            flags = Flag.BOOLEAN;
            bytes = new byte[]{(Boolean)value != false ? (byte)49 : 48};
        } else if (value instanceof Integer || value instanceof Long || value instanceof Byte || value instanceof Short) {
            bytes = value.toString().getBytes(ASCII_CHARSET);
            flags = value instanceof Integer ? Flag.INTEGER : (value instanceof Long ? Flag.LONG : (value instanceof Byte ? Flag.BYTE : Flag.SHORT));
        } else if (value instanceof String) {
            flags = Flag.UTF8;
            bytes = ((String)value).getBytes(UTF8_CHARSET);
        } else if (value instanceof Serializable) {
            flags = Flag.OBJECT;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream objOut = new ObjectOutputStream(baos);
            objOut.writeObject(value);
            objOut.close();
            bytes = baos.toByteArray();
        } else {
            throw new IllegalArgumentException("can't accept " + value.getClass() + " as a memcache entity");
        }
        return new ValueAndFlags(bytes, flags);
    }

    static {
        try {
            SHA1 = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException ex) {
            Logger.getLogger(MYCLASSNAME).log(Level.SEVERE, "Can't load SHA-1 MessageDigest!", ex);
            throw new MemcacheServiceException("No SHA-1 algorithm, cannot hash keys for memcache", ex);
        }
    }

    public static class ValueAndFlags {
        public final byte[] value;
        public final Flag flags;

        private ValueAndFlags(byte[] value, Flag flags) {
            this.value = value;
            this.flags = flags;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Flag {
        BYTES,
        UTF8,
        OBJECT,
        INTEGER,
        LONG,
        BOOLEAN,
        BYTE,
        SHORT;


        public static Flag fromInt(int i) {
            if (i < 0 || i >= Flag.values().length) {
                throw new IllegalArgumentException();
            }
            return Flag.values()[i];
        }
    }
}

