/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ByteArrays {
    private static final char[] HEX_DIGITS = "0123456789abcdef".toCharArray();

    public static String toHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(2 * bytes.length);
        for (byte b : bytes) {
            sb.append(HEX_DIGITS[b >> 4 & 0xF]).append(HEX_DIGITS[b & 0xF]);
        }
        return sb.toString();
    }

    public static Comparator<byte[]> getUnsignedLexicographicalByteArrayComparator() {
        return UnsignedLexicographicalByteArrayComparator.UNSIGNED_LEXICOGRAPHICAL;
    }

    public static int compareUnsignedLexicographical(byte[] bytes1, int offset1, int length1, byte[] bytes2, int offset2, int length2) {
        Preconditions.checkNotNull(bytes1);
        Preconditions.checkNotNull(bytes2);
        Preconditions.checkArgument(offset1 >= 0, "must be non-negative: %s", offset1);
        Preconditions.checkArgument(length1 >= 0, "must be non-negative: %s", length1);
        Preconditions.checkArgument(offset2 >= 0, "must be non-negative: %s", offset2);
        Preconditions.checkArgument(length2 >= 0, "must be non-negative: %s", length2);
        Preconditions.checkArgument(offset1 + length1 <= bytes1.length, "out of bounds");
        Preconditions.checkArgument(offset2 + length2 <= bytes2.length, "out of bounds");
        int n = offset1 + Math.min(length1, length2);
        int i = offset1;
        int j = offset2;
        while (i < n) {
            int v1 = bytes1[i] & 0xFF;
            int v2 = bytes2[j] & 0xFF;
            if (v1 != v2) {
                return v1 - v2;
            }
            ++i;
            ++j;
        }
        return length1 - length2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum UnsignedLexicographicalByteArrayComparator implements Comparator<byte[]>
    {
        UNSIGNED_LEXICOGRAPHICAL;


        @Override
        public int compare(byte[] a, byte[] b) {
            return ByteArrays.compareUnsignedLexicographical(a, 0, a.length, b, 0, b.length);
        }
    }
}

