/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.io.protocol;

import com.google.appengine.repackaged.com.google.common.base.CharEscapers;
import com.google.appengine.repackaged.com.google.common.io.Bytes;
import com.google.appengine.repackaged.com.google.common.io.InputSupplier;
import com.google.appengine.repackaged.com.google.io.base.IORuntimeException;
import com.google.appengine.repackaged.com.google.io.protocol.MessageAppender;
import com.google.appengine.repackaged.com.google.io.protocol.MessageSet;
import com.google.appengine.repackaged.com.google.io.protocol.MessageVisitor;
import com.google.appengine.repackaged.com.google.io.protocol.Protocol;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSink;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSource;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSupport;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolType;
import java.awt.Image;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.EnumSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProtocolMessage<T extends ProtocolMessage<T>>
implements Serializable,
BeanInfo {
    private static final String[] formattedHex = new String[256];
    private static final EnumSet<PrintFlag> FLAGS_DEFAULT;
    private static final EnumSet<PrintFlag> FLAGS_WITH_INDEX;

    public abstract String findInitializationError();

    public final boolean isInitialized() {
        return this.findInitializationError() == null;
    }

    public abstract int encodingSize();

    public abstract int maxEncodingSize();

    public abstract void clear();

    public abstract T newInstance();

    public T freeze() {
        return (T)this;
    }

    public T unfreeze() {
        return (T)this;
    }

    public boolean isFrozen() {
        return false;
    }

    public abstract T mergeFrom(T var1);

    public T copyFrom(T that) {
        if (that == this) {
            return that;
        }
        this.clear();
        return this.mergeFrom(that);
    }

    public T clone() {
        ProtocolMessage copy = this.newInstance();
        copy.mergeFrom((ProtocolMessage)this);
        return (T)copy;
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract boolean equals(T var1);

    public abstract boolean equalsIgnoreUninterpreted(T var1);

    public abstract boolean equals(T var1, boolean var2);

    public abstract void outputTo(ProtocolSink var1);

    public final ProtocolSink toProtocolSink() {
        ProtocolSink sink = new ProtocolSink(this.maxEncodingSize());
        this.outputTo(sink);
        return sink;
    }

    public final void outputTo(byte[] buf, int offset) {
        this.outputTo(new ProtocolSink(buf, offset));
    }

    public final byte[] toByteArray() {
        return this.toProtocolSink().toArray();
    }

    public final void outputTo(ByteBuffer buffer) {
        if (buffer.hasArray()) {
            int offset = buffer.arrayOffset();
            ProtocolSink sink = new ProtocolSink(buffer.array(), offset + buffer.position());
            this.outputTo(sink);
            if (sink.position() - offset > buffer.limit()) {
                throw new BufferOverflowException();
            }
            buffer.position(sink.position() - offset);
        } else {
            ProtocolSink sink = this.toProtocolSink();
            buffer.put(sink.array(), 0, sink.position());
        }
    }

    public final ByteBuffer toByteBuffer() {
        ProtocolSink sink = this.toProtocolSink();
        return ByteBuffer.wrap(sink.array(), 0, sink.position()).order(ByteOrder.LITTLE_ENDIAN);
    }

    public final void outputTo(OutputStream stream) {
        try {
            ProtocolSink sink = this.toProtocolSink();
            stream.write(sink.array(), 0, sink.position());
        }
        catch (IOException ioe) {
            throw new IORuntimeException(ioe);
        }
    }

    protected abstract boolean merge(ProtocolSource var1);

    public final boolean mergeFrom(ProtocolSource source) {
        try {
            return this.merge(source);
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public final boolean mergeFrom(byte[] buf) {
        return this.mergeFrom(new ProtocolSource(buf));
    }

    public final boolean mergeFrom(byte[] buf, int offset, int length) {
        return this.mergeFrom(new ProtocolSource(buf, offset, length));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean mergeFrom(ByteBuffer buffer) {
        try {
            ProtocolSource source = new ProtocolSource(buffer);
            boolean bl = this.mergeFrom(source);
            return bl;
        }
        catch (BufferUnderflowException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            buffer.position(buffer.limit());
        }
    }

    public final boolean mergeFrom(InputStream in) {
        try {
            return this.mergeFrom(Bytes.toByteArray(in));
        }
        catch (IOException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean mergeFrom(InputSupplier<? extends InputStream> supplier) {
        boolean bl;
        InputStream in = supplier.getInput();
        try {
            bl = this.mergeFrom(Bytes.toByteArray(in));
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        in.close();
        return bl;
    }

    public final boolean parseFrom(ProtocolSource source) {
        this.clear();
        return this.mergeFrom(source);
    }

    public final boolean parseFrom(byte[] buf) {
        this.clear();
        return this.mergeFrom(buf);
    }

    public final boolean parseFrom(byte[] buf, int offset, int length) {
        this.clear();
        return this.mergeFrom(buf, offset, length);
    }

    public final boolean parseFrom(ByteBuffer buf) {
        this.clear();
        return this.mergeFrom(buf);
    }

    public final boolean parseFrom(InputStream in) {
        this.clear();
        return this.mergeFrom(in);
    }

    public final boolean parseFrom(InputSupplier<? extends InputStream> supplier) {
        this.clear();
        return this.mergeFrom(supplier);
    }

    public MessageAppender getMessageAppender() {
        return null;
    }

    public String toString() {
        return this.toString("", false);
    }

    public String toString(PrintFlag ... flags) {
        Set<PrintFlag> flagSet = ProtocolMessage.toEnumSet(flags);
        return this.toString("", flagSet);
    }

    public String toString(Set<PrintFlag> flags) {
        return this.toString("", flags);
    }

    public String toString(boolean printIndex) {
        return this.toString("", printIndex);
    }

    public String toString(String prefix, boolean printIndex) {
        return this.toString(prefix, printIndex ? FLAGS_WITH_INDEX : FLAGS_DEFAULT);
    }

    public String toString(String prefix, Set<PrintFlag> flags) {
        StringBuilder sb = new StringBuilder();
        this.outputText(sb, prefix, flags);
        if (sb.length() > 0 && !flags.contains((Object)PrintFlag.FLATTEN)) {
            sb.append("\n");
        }
        return sb.toString();
    }

    public String toString(int maxChars, PrintFlag ... flags) {
        if (maxChars < 3) {
            return "...";
        }
        Set<PrintFlag> flagSet = ProtocolMessage.toEnumSet(flags);
        StringBuilder sb = new StringBuilder();
        BoundedAsciiVisitor visitor = new BoundedAsciiVisitor(sb, "", flagSet, maxChars);
        visitor.visit(this);
        if (!((AbstractVisitor)visitor).canAccept() && sb.length() > 0) {
            boolean endedWithQuote = sb.charAt(sb.length() - 1) == '\"';
            sb.delete(maxChars - 4, sb.length()).append("...");
            if (endedWithQuote) {
                sb.append('\"');
            }
        }
        return sb.toString();
    }

    public String toFlatString(int maxChars) {
        return this.toString(maxChars, PrintFlag.FLATTEN);
    }

    public String toFlatString() {
        return this.toFlatString(false);
    }

    public String toFlatString(boolean printIndex) {
        EnumSet<PrintFlag> flags = EnumSet.of(PrintFlag.FLATTEN);
        if (printIndex) {
            flags.add(PrintFlag.SHOW_ELEMENT_NUMBERS);
        }
        return this.outputText(new StringBuilder(), null, flags).toString();
    }

    private static Set<PrintFlag> toEnumSet(PrintFlag ... flags) {
        EnumSet<PrintFlag> flagSet = EnumSet.noneOf(PrintFlag.class);
        for (PrintFlag flag : flags) {
            flagSet.add(flag);
        }
        return flagSet;
    }

    private StringBuilder outputText(StringBuilder sb, String prefix, Set<PrintFlag> flags) {
        new AsciiVisitor(sb, prefix, flags).visit(this);
        return sb;
    }

    public String toXmlString() {
        StringBuilder sb = new StringBuilder("<?xml version=\"1.0\"?>\n<toplevel>\n");
        new XmlVisitor(sb, "  ").visit(this);
        return sb.append("\n</toplevel>\n").toString();
    }

    public abstract ProtocolType getProtocolType();

    @Override
    public BeanDescriptor getBeanDescriptor() {
        return null;
    }

    @Override
    public PropertyDescriptor[] getPropertyDescriptors() {
        if (this.getClass() != ProtocolMessage.class) {
            return this.getProtocolType().getPropertyDescriptors();
        }
        return null;
    }

    @Override
    public int getDefaultPropertyIndex() {
        return -1;
    }

    @Override
    public EventSetDescriptor[] getEventSetDescriptors() {
        return null;
    }

    @Override
    public int getDefaultEventIndex() {
        return -1;
    }

    @Override
    public MethodDescriptor[] getMethodDescriptors() {
        return null;
    }

    @Override
    public BeanInfo[] getAdditionalBeanInfo() {
        return null;
    }

    @Override
    public Image getIcon(int iconKind) {
        return null;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            ProtocolMessage.formattedHex[i] = String.format("0x%02x ", i);
        }
        FLAGS_DEFAULT = EnumSet.of(PrintFlag.ALLOW_NULL);
        FLAGS_WITH_INDEX = EnumSet.of(PrintFlag.SHOW_ELEMENT_NUMBERS);
    }

    private class XmlVisitor
    extends AbstractVisitor {
        XmlVisitor(StringBuilder sb, String prefix) {
            super(sb, prefix, EnumSet.noneOf(PrintFlag.class));
        }

        public void visitBoolean(ProtocolType.FieldType ti, int index, boolean value) {
            this.header(ti, index);
            this.append(" bool=\"", value, "\"/>");
        }

        public void visitInteger(ProtocolType.FieldType ti, int index, int value) {
            this.header(ti, index);
            this.append(" int=\"", value, "\"/>");
        }

        public void visitLong(ProtocolType.FieldType ti, int index, long value) {
            this.header(ti, index);
            this.append(" long=\"", value, "\"/>");
        }

        public void visitByteArray(ProtocolType.FieldType ti, int index, byte[] value) {
            this.header(ti, index);
            this.append(" data=\"", CharEscapers.xmlEscaper().escape(Protocol.toStringUtf8(value)), "\"/>");
        }

        public void visitString(ProtocolType.FieldType ti, int index, String value) {
            this.header(ti, index);
            this.append(" data=\"", CharEscapers.xmlEscaper().escape(value), "\"/>");
        }

        public void visitFloat(ProtocolType.FieldType ti, int index, float value) {
            this.header(ti, index);
            this.append(" float=\"", Float.valueOf(value), "\"/>");
        }

        public void visitDouble(ProtocolType.FieldType ti, int index, double value) {
            this.header(ti, index);
            this.append(" double=\"", value, "\"/>");
        }

        public void visitGroup(ProtocolType.FieldType ti, int index, ProtocolMessage value) {
            this.visitCollection(ti, index, value, ">", "</" + CharEscapers.xmlEscaper().escape(ti.getName()) + ">");
        }

        public void visitForeign(ProtocolType.FieldType ti, int index, ProtocolMessage value) {
            this.visitGroup(ti, index, value);
        }

        protected void header(ProtocolType.FieldType ti, int index) {
            this.separator();
            this.prefix();
            this.append("<", CharEscapers.xmlEscaper().escape(ti.getName()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BoundedAsciiVisitor
    extends AsciiVisitor {
        int maxChars = 0;

        BoundedAsciiVisitor(StringBuilder sb, String prefix, Set<PrintFlag> flags, int maxChars) {
            super(sb, prefix, flags);
            this.maxChars = maxChars;
        }

        private int availableSpace() {
            return this.maxChars - this.sb.length();
        }

        @Override
        public boolean canAccept() {
            return this.availableSpace() > 0;
        }

        @Override
        public void visitByteArray(ProtocolType.FieldType ti, int index, byte[] value) {
            this.header(ti, index);
            byte[] bytesToStore = this.binaryString ? ti.getRawByteArray(this.node, index) : value;
            int nBytes = Math.max(0, Math.min(bytesToStore.length, this.availableSpace() - 4));
            String stringValue = this.binaryString ? new String(ti.getRawByteArray(this.node, index), 0, 0, nBytes) : ProtocolSupport.toStringUtf8(value, 0, nBytes);
            this.appendString(stringValue);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AsciiVisitor
    extends AbstractVisitor {
        AsciiVisitor(StringBuilder sb, String prefix, Set<PrintFlag> flags) {
            super(sb, prefix, flags);
        }

        @Override
        public void visitBoolean(ProtocolType.FieldType ti, int index, boolean value) {
            this.header(ti, index);
            this.append(": ", value);
        }

        @Override
        public void visitInteger(ProtocolType.FieldType ti, int index, int value) {
            this.header(ti, index);
            this.append(": ");
            ProtocolType.FieldBaseType type = ti.getBaseType();
            Class<? extends Enum> enumType = ti.getEnumType();
            if (enumType != null && this.flags.contains((Object)PrintFlag.PRINT_ENUMS)) {
                try {
                    Method method = enumType.getMethod("valueOf", Integer.TYPE);
                    Enum e = (Enum)method.invoke(null, value);
                    if (e != null) {
                        this.append(e);
                        return;
                    }
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            if (!this.numberAlwaysDecimal && (value >= 2000000000 || value <= -2000000000 || type.isFixed())) {
                this.append("0x", Integer.toHexString(value));
            } else {
                this.append(value);
            }
        }

        @Override
        public void visitLong(ProtocolType.FieldType ti, int index, long value) {
            this.header(ti, index);
            this.append(": ");
            ProtocolType.FieldBaseType type = ti.getBaseType();
            if (!this.numberAlwaysDecimal && (value >= 2000000000L || value <= -2000000000L || type.isFixed())) {
                this.append("0x", Long.toHexString(value));
            } else {
                this.append(value);
            }
        }

        @Override
        public void visitString(ProtocolType.FieldType ti, int index, String value) {
            this.header(ti, index);
            this.appendString(this.binaryString ? new String(ti.getRawByteArray(this.node, index), 0) : value);
        }

        @Override
        public void visitFloat(ProtocolType.FieldType ti, int index, float value) {
            this.header(ti, index);
            this.append(": ", Float.valueOf(value), "f");
        }

        @Override
        public void visitDouble(ProtocolType.FieldType ti, int index, double value) {
            this.header(ti, index);
            this.append(": ", value);
        }

        @Override
        public void visitByteArray(ProtocolType.FieldType ti, int index, byte[] value) {
            this.header(ti, index);
            String stringValue = this.binaryString ? new String(ti.getRawByteArray(this.node, index), 0) : ProtocolSupport.toStringUtf8(value);
            this.appendString(stringValue);
        }

        @Override
        public void visitGroup(ProtocolType.FieldType ti, int index, ProtocolMessage value) {
            this.visitCollection(ti, index, value, " {", "}");
        }

        @Override
        public void visitForeign(ProtocolType.FieldType ti, int index, ProtocolMessage value) {
            this.visitCollection(ti, index, value, " <", ">");
        }

        @Override
        public void visitNull() {
            this.separator();
            this.prefix();
            this.append("ILLEGAL_NULL_VALUE");
        }

        @Override
        protected void header(ProtocolType.FieldType ti, int index) {
            this.separator();
            this.prefix();
            if (ti instanceof MessageSet.FieldType) {
                this.append("[", ti.getName(), "]");
            } else {
                this.append(ti.getName());
            }
            if (this.flags.contains((Object)PrintFlag.SHOW_ELEMENT_NUMBERS) && index >= 0 && ti.getPresence() == ProtocolType.Presence.REPEATED) {
                this.append("(", index, ")");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AbstractVisitor
    implements MessageVisitor {
        protected final StringBuilder sb;
        protected final Set<PrintFlag> flags;
        protected final char separator;
        protected final String newline;
        protected final boolean numberAlwaysDecimal;
        protected final boolean escapeString;
        protected final boolean binaryString;
        protected final String prefix;
        private final String alignment = "  ";
        private int depth = -1;
        private boolean needSeparator = false;
        protected ProtocolMessage node;

        protected AbstractVisitor(StringBuilder sb, String prefix, Set<PrintFlag> flags) {
            this.sb = sb;
            this.flags = flags;
            this.separator = (char)(flags.contains((Object)PrintFlag.FLATTEN) ? 44 : 10);
            this.newline = flags.contains((Object)PrintFlag.FLATTEN) ? "" : "\n";
            this.numberAlwaysDecimal = flags.contains((Object)PrintFlag.NUMBERS_ALWAYS_DECIMAL);
            this.escapeString = !flags.contains((Object)PrintFlag.NO_ESCAPE_STRINGS);
            this.binaryString = flags.contains((Object)PrintFlag.BINARY_STRINGS);
            this.prefix = prefix;
        }

        void visit(ProtocolMessage protocolMessage) {
            boolean neededSeparator = this.needSeparator;
            this.needSeparator = false;
            ProtocolMessage previousNode = this.node;
            this.node = protocolMessage;
            ++this.depth;
            this.newline();
            if (protocolMessage != null) {
                ProtocolType.visit(protocolMessage, this);
                this.newline();
            } else {
                this.visitNull();
            }
            --this.depth;
            this.needSeparator = neededSeparator;
            this.node = previousNode;
        }

        protected void visitCollection(ProtocolType.FieldType ti, int index, ProtocolMessage collection, String opener, String closer) {
            this.header(ti, index);
            if (collection == null) {
                this.visit(collection);
            } else {
                this.append(opener);
                this.visit(collection);
                this.prefix();
                this.append(closer);
            }
        }

        public boolean canAccept() {
            return true;
        }

        @Override
        public boolean shouldVisitField(ProtocolType.FieldType ti, int count) {
            return this.canAccept();
        }

        @Override
        public abstract void visitForeign(ProtocolType.FieldType var1, int var2, ProtocolMessage var3);

        @Override
        public void visitRawMessage(ByteBuffer value) {
            while (value.remaining() > 0 && this.canAccept()) {
                this.separator();
                this.prefix();
                for (int j = 0; j < 16 && value.remaining() > 0 && this.canAccept(); ++j) {
                    this.append(formattedHex[value.get() & 0xFF]);
                }
            }
        }

        protected void visitNull() {
            throw new NullPointerException();
        }

        protected void prefix() {
            if (this.prefix != null) {
                this.append(this.prefix);
                for (int i = 0; i < this.depth; ++i) {
                    this.append("  ");
                }
            }
        }

        protected void separator() {
            if (this.needSeparator) {
                this.append(Character.valueOf(this.separator));
            }
            this.needSeparator = true;
        }

        private void newline() {
            if (this.depth > 0) {
                this.append(this.newline);
            }
        }

        protected void append(Object ... parts) {
            for (Object part : parts) {
                this.sb.append(part.toString());
            }
        }

        protected void appendString(String s) {
            this.append(": \"", this.escapeString ? CharEscapers.javaStringEscaper().escape(s) : s, "\"");
        }

        protected abstract void header(ProtocolType.FieldType var1, int var2);

        public void visit(ByteBuffer message) {
            this.visitRawMessage(message);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PrintFlag {
        SHOW_ELEMENT_NUMBERS,
        PRINT_ENUMS,
        FLATTEN,
        NUMBERS_ALWAYS_DECIMAL,
        NO_ESCAPE_STRINGS,
        BINARY_STRINGS,
        ALLOW_NULL;

    }
}

