/*
 * Copyright 2013 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.junit.client.impl;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.SingleJsoImpl;
import com.google.gwt.junit.client.GWTTestCase;

/**
 * A proxy generated by code generator to provide access to user agent property and reflective
 * capabilities for GWTTestCase.
 */
public interface GWTRunnerProxy {

  /**
   * A helper to provide create/execute functionality over GWTTestCase using names.
   */
  @SingleJsoImpl(JsniTestAccessor.class)
  interface TestAccessor {
    GWTTestCase newInstance(String className) throws Throwable;
    Object invoke(GWTTestCase object, String className, String methodName) throws Throwable;
  }

  /**
   * Creates a new {@link TestAccessor} for the module under test.
   */
  TestAccessor createTestAccessor();

  /**
   * Return the user agent property.
   */
  String getUserAgentProperty();


  /**
   * A JSNI + codegen based {@link TestAccessor} implementation.
   */
  class JsniTestAccessor extends JavaScriptObject implements TestAccessor {

    protected JsniTestAccessor() { /* empty */}

    @Override
    public final GWTTestCase newInstance(String className) {
      return (GWTTestCase) invoke(null, className, "new");
    }

    @Override
    public final native Object invoke(GWTTestCase o, String className, String methodName) /*-{
      return this[className][methodName](o);
    }-*/;
  }
}
