/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.tiff.fieldtypes;

import org.apache.sanselan.ImageWriteException;
import org.apache.sanselan.common.RationalNumber;
import org.apache.sanselan.formats.tiff.TiffField;
import org.apache.sanselan.formats.tiff.fieldtypes.FieldType;

public class FieldTypeRational
extends FieldType {
    public FieldTypeRational(int type, String name) {
        super(type, 8, name);
    }

    public Object getSimpleValue(TiffField entry) {
        if (entry.length == 1) {
            return this.convertByteArrayToRational(this.name + " (" + entry.tagInfo.name + ")", entry.oversizeValue, entry.byteOrder);
        }
        return this.convertByteArrayToRationalArray(this.name + " (" + entry.tagInfo.name + ")", this.getRawBytes(entry), 0, entry.length, entry.byteOrder);
    }

    public byte[] writeData(Object o, int byteOrder) throws ImageWriteException {
        if (o instanceof RationalNumber) {
            return this.convertRationalToByteArray((RationalNumber)o, byteOrder);
        }
        return this.convertRationalArrayToByteArray((RationalNumber[])o, byteOrder);
    }

    public byte[] writeData(int numerator, int denominator, int byteOrder) throws ImageWriteException {
        return this.writeData(new int[]{numerator}, new int[]{denominator}, byteOrder);
    }

    public byte[] writeData(int[] numerators, int[] denominators, int byteOrder) throws ImageWriteException {
        return this.convertIntArrayToRationalArray(numerators, denominators, byteOrder);
    }
}

