/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.common;

import java.text.NumberFormat;

public class RationalNumber
extends Number {
    public final int numerator;
    public final int divisor;

    public RationalNumber(int numerator, int divisor) {
        this.numerator = numerator;
        this.divisor = divisor;
    }

    public double doubleValue() {
        return (double)this.numerator / (double)this.divisor;
    }

    public float floatValue() {
        return (float)this.numerator / (float)this.divisor;
    }

    public int intValue() {
        return this.numerator / this.divisor;
    }

    public long longValue() {
        return (long)this.numerator / (long)this.divisor;
    }

    public String toString() {
        if (this.divisor == 0) {
            return "Invalid rational number; Numerator: " + this.numerator + ", Divisor: " + this.divisor;
        }
        if (this.numerator % this.divisor == 0) {
            return "" + this.numerator / this.divisor;
        }
        return this.numerator + "/" + this.divisor;
    }

    public String toDisplayString() {
        if (this.numerator % this.divisor == 0) {
            return "" + this.numerator / this.divisor;
        }
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumFractionDigits(3);
        return nf.format((double)this.numerator / (double)this.divisor);
    }
}

