/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.common.mylzw;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.sanselan.common.mylzw.MyBitOutputStream;

public class MyLZWCompressor {
    private int codeSize;
    private final int initialCodeSize;
    private int codes = -1;
    private final int byteOrder;
    private final boolean earlyLimit;
    private final int clearCode;
    private final int eoiCode;
    private final Map map = new HashMap();

    public MyLZWCompressor(int initialCodeSize, int byteOrder, boolean early_limit) {
        this.byteOrder = byteOrder;
        this.earlyLimit = early_limit;
        this.initialCodeSize = initialCodeSize;
        this.clearCode = 1 << initialCodeSize;
        this.eoiCode = this.clearCode + 1;
        this.InitializeStringTable();
    }

    private final void InitializeStringTable() {
        this.codeSize = this.initialCodeSize;
        int intial_entries_count = (1 << this.codeSize) + 2;
        this.map.clear();
        this.codes = 0;
        while (this.codes < intial_entries_count) {
            if (this.codes != this.clearCode && this.codes != this.eoiCode) {
                Object key = this.arrayToKey((byte)this.codes);
                this.map.put(key, new Integer(this.codes));
            }
            ++this.codes;
        }
    }

    private final void clearTable() {
        this.InitializeStringTable();
        this.incrementCodeSize();
    }

    private final void incrementCodeSize() {
        if (this.codeSize != 12) {
            ++this.codeSize;
        }
    }

    private final Object arrayToKey(byte b) {
        return this.arrayToKey(new byte[]{b}, 0, 1);
    }

    private final Object arrayToKey(byte[] bytes, int start, int length) {
        return new ByteArray(bytes, start, length);
    }

    private final void writeCode(MyBitOutputStream bos, int code) throws IOException {
        bos.writeBits(code, this.codeSize);
    }

    private final boolean isInTable(byte[] bytes, int start, int length) {
        Object key = this.arrayToKey(bytes, start, length);
        return this.map.containsKey(key);
    }

    private final int codeFromString(byte[] bytes, int start, int length) throws IOException {
        Object key = this.arrayToKey(bytes, start, length);
        Object o = this.map.get(key);
        if (o == null) {
            throw new IOException("CodeFromString");
        }
        return (Integer)o;
    }

    private final boolean addTableEntry(MyBitOutputStream bos, byte[] bytes, int start, int length) throws IOException {
        Object key = this.arrayToKey(bytes, start, length);
        return this.addTableEntry(bos, key);
    }

    private final boolean addTableEntry(MyBitOutputStream bos, Object key) throws IOException {
        boolean cleared = false;
        int limit = 1 << this.codeSize;
        if (this.earlyLimit) {
            --limit;
        }
        if (this.codes == limit) {
            if (this.codeSize < 12) {
                this.incrementCodeSize();
            } else {
                this.writeCode(bos, this.clearCode);
                this.clearTable();
                cleared = true;
            }
        }
        if (!cleared) {
            this.map.put(key, new Integer(this.codes));
            ++this.codes;
        }
        return cleared;
    }

    public byte[] compress(byte[] bytes) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(bytes.length);
        MyBitOutputStream bos = new MyBitOutputStream(baos, this.byteOrder);
        this.InitializeStringTable();
        this.clearTable();
        this.writeCode(bos, this.clearCode);
        boolean cleared = false;
        int w_start = 0;
        int w_length = 0;
        for (int i = 0; i < bytes.length; ++i) {
            if (this.isInTable(bytes, w_start, w_length + 1)) {
                ++w_length;
                cleared = false;
                continue;
            }
            this.writeCode(bos, this.codeFromString(bytes, w_start, w_length));
            cleared = this.addTableEntry(bos, bytes, w_start, w_length + 1);
            w_start = i;
            w_length = 1;
        }
        this.writeCode(bos, this.codeFromString(bytes, w_start, w_length));
        this.writeCode(bos, this.eoiCode);
        bos.flushCache();
        return baos.toByteArray();
    }

    private static final class ByteArray {
        private final byte[] bytes;
        private final int start;
        private final int length;
        private final int hash;

        public ByteArray(byte[] bytes) {
            this(bytes, 0, bytes.length);
        }

        public ByteArray(byte[] bytes, int start, int length) {
            this.bytes = bytes;
            this.start = start;
            this.length = length;
            int tempHash = length;
            for (int i = 0; i < length; ++i) {
                int b = 0xFF & bytes[i + start];
                tempHash = tempHash + (tempHash << 8) ^ b ^ i;
            }
            this.hash = tempHash;
        }

        public final int hashCode() {
            return this.hash;
        }

        public final boolean equals(Object o) {
            ByteArray other = (ByteArray)o;
            if (other.hash != this.hash) {
                return false;
            }
            if (other.length != this.length) {
                return false;
            }
            for (int i = 0; i < this.length; ++i) {
                if (other.bytes[i + other.start] == this.bytes[i + this.start]) continue;
                return false;
            }
            return true;
        }
    }
}

