/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.pnm;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.apache.sanselan.ImageFormat;
import org.apache.sanselan.ImageInfo;
import org.apache.sanselan.ImageParser;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.ImageWriteException;
import org.apache.sanselan.common.IImageMetadata;
import org.apache.sanselan.common.byteSources.ByteSource;
import org.apache.sanselan.formats.pnm.FileInfo;
import org.apache.sanselan.formats.pnm.PBMFileInfo;
import org.apache.sanselan.formats.pnm.PBMWriter;
import org.apache.sanselan.formats.pnm.PGMFileInfo;
import org.apache.sanselan.formats.pnm.PGMWriter;
import org.apache.sanselan.formats.pnm.PNMWriter;
import org.apache.sanselan.formats.pnm.PPMFileInfo;
import org.apache.sanselan.formats.pnm.PPMWriter;
import org.apache.sanselan.formats.pnm.WhiteSpaceReader;
import org.apache.sanselan.util.Debug;

public class PNMImageParser
extends ImageParser {
    private static final String DEFAULT_EXTENSION = ".pnm";
    private static final String[] ACCEPTED_EXTENSIONS = new String[]{".pbm", ".pgm", ".ppm", ".pnm"};
    public static final String PARAM_KEY_PNM_RAWBITS = "PNM_RAWBITS";
    public static final String PARAM_VALUE_PNM_RAWBITS_YES = "YES";
    public static final String PARAM_VALUE_PNM_RAWBITS_NO = "NO";

    public PNMImageParser() {
        super.setByteOrder(73);
    }

    public String getName() {
        return "Pbm-Custom";
    }

    public String getDefaultExtension() {
        return DEFAULT_EXTENSION;
    }

    protected String[] getAcceptedExtensions() {
        return ACCEPTED_EXTENSIONS;
    }

    protected ImageFormat[] getAcceptedTypes() {
        return new ImageFormat[]{ImageFormat.IMAGE_FORMAT_PBM, ImageFormat.IMAGE_FORMAT_PGM, ImageFormat.IMAGE_FORMAT_PPM, ImageFormat.IMAGE_FORMAT_PNM};
    }

    private FileInfo readHeader(InputStream is) throws ImageReadException, IOException {
        byte Identifier1 = this.readByte("Identifier1", is, "Not a Valid PNM File");
        byte Identifier2 = this.readByte("Identifier2", is, "Not a Valid PNM File");
        WhiteSpaceReader wsr = new WhiteSpaceReader(is);
        int width = Integer.parseInt(wsr.readtoWhiteSpace());
        int height = Integer.parseInt(wsr.readtoWhiteSpace());
        if (Identifier1 == 80 && Identifier2 == 49) {
            return new PBMFileInfo(width, height, false);
        }
        if (Identifier1 == 80 && Identifier2 == 50) {
            int maxgray = Integer.parseInt(wsr.readtoWhiteSpace());
            return new PGMFileInfo(width, height, false, maxgray);
        }
        if (Identifier1 == 80 && Identifier2 == 51) {
            int max = Integer.parseInt(wsr.readtoWhiteSpace());
            return new PPMFileInfo(width, height, false, max);
        }
        if (Identifier1 == 80 && Identifier2 == 52) {
            return new PBMFileInfo(width, height, true);
        }
        if (Identifier1 == 80 && Identifier2 == 53) {
            int maxgray = Integer.parseInt(wsr.readtoWhiteSpace());
            return new PGMFileInfo(width, height, true, maxgray);
        }
        if (Identifier1 == 80 && Identifier2 == 54) {
            int max = Integer.parseInt(wsr.readtoWhiteSpace());
            return new PPMFileInfo(width, height, true, max);
        }
        throw new ImageReadException("PNM: Bad Magic Number: " + Identifier1 + ", " + Identifier2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileInfo readHeader(ByteSource byteSource) throws ImageReadException, IOException {
        InputStream is = null;
        try {
            is = byteSource.getInputStream();
            FileInfo fileInfo = this.readHeader(is);
            return fileInfo;
        }
        finally {
            try {
                is.close();
            }
            catch (Exception e) {
                Debug.debug(e);
            }
        }
    }

    public byte[] getICCProfileBytes(ByteSource byteSource) throws ImageReadException, IOException {
        return null;
    }

    public Dimension getImageSize(ByteSource byteSource) throws ImageReadException, IOException {
        FileInfo info = this.readHeader(byteSource);
        if (info == null) {
            throw new ImageReadException("PNM: Couldn't read Header");
        }
        return new Dimension(info.width, info.height);
    }

    public byte[] embedICCProfile(byte[] image, byte[] profile) {
        return null;
    }

    public boolean embedICCProfile(File src, File dst, byte[] profile) {
        return false;
    }

    public IImageMetadata getMetadata(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        return null;
    }

    public ImageInfo getImageInfo(ByteSource byteSource) throws ImageReadException, IOException {
        FileInfo info = this.readHeader(byteSource);
        if (info == null) {
            throw new ImageReadException("PNM: Couldn't read Header");
        }
        Vector Comments = new Vector();
        int BitsPerPixel = info.getBitDepth() * info.getNumComponents();
        ImageFormat Format2 = info.getImageType();
        String FormatName = info.getImageTypeDescription();
        String MimeType = info.getMIMEType();
        int NumberOfImages = 1;
        boolean isProgressive = false;
        int PhysicalWidthDpi = 72;
        float PhysicalWidthInch = (float)((double)info.width / (double)PhysicalWidthDpi);
        int PhysicalHeightDpi = 72;
        float PhysicalHeightInch = (float)((double)info.height / (double)PhysicalHeightDpi);
        String FormatDetails = info.getImageTypeDescription();
        boolean isTransparent = false;
        boolean usesPalette = false;
        int ColorType = info.getColorType();
        String compressionAlgorithm = "None";
        ImageInfo result = new ImageInfo(FormatDetails, BitsPerPixel, Comments, Format2, FormatName, info.height, MimeType, NumberOfImages, PhysicalHeightDpi, PhysicalHeightInch, PhysicalWidthDpi, PhysicalWidthInch, info.width, isProgressive, isTransparent, usesPalette, ColorType, compressionAlgorithm);
        return result;
    }

    public boolean dumpImageFile(PrintWriter pw, ByteSource byteSource) throws ImageReadException, IOException {
        pw.println("pnm.dumpImageFile");
        ImageInfo fImageData = this.getImageInfo(byteSource);
        if (fImageData == null) {
            return false;
        }
        fImageData.toString(pw, "");
        pw.println("");
        return true;
    }

    private int[] getColorTable(byte[] bytes) throws ImageReadException, IOException {
        if (bytes.length % 3 != 0) {
            throw new ImageReadException("Bad Color Table Length: " + bytes.length);
        }
        int length = bytes.length / 3;
        int[] result = new int[length];
        for (int i = 0; i < length; ++i) {
            int rgb;
            int red = 0xFF & bytes[i * 3 + 0];
            int green = 0xFF & bytes[i * 3 + 1];
            int blue = 0xFF & bytes[i * 3 + 2];
            int alpha = 255;
            result[i] = rgb = alpha << 24 | red << 16 | green << 8 | blue << 0;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getBufferedImage(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        InputStream is = null;
        try {
            is = byteSource.getInputStream();
            FileInfo info = this.readHeader(is);
            int width = info.width;
            int height = info.height;
            boolean hasAlpha = false;
            BufferedImage result = this.getBufferedImageFactory(params).getColorBufferedImage(width, height, hasAlpha);
            info.readImage(result, is);
            BufferedImage bufferedImage = result;
            return bufferedImage;
        }
        finally {
            try {
                is.close();
            }
            catch (Exception e) {
                Debug.debug(e);
            }
        }
    }

    public void writeImage(BufferedImage src, OutputStream os, Map params) throws ImageWriteException, IOException {
        PNMWriter writer = null;
        boolean RAWBITS = true;
        if (params != null) {
            Object subtype;
            Object fRAWBITS = params.get(PARAM_KEY_PNM_RAWBITS);
            if (fRAWBITS != null && fRAWBITS.equals(PARAM_VALUE_PNM_RAWBITS_NO)) {
                RAWBITS = false;
            }
            if ((subtype = params.get("FORMAT")) != null) {
                if (subtype.equals(ImageFormat.IMAGE_FORMAT_PBM)) {
                    writer = new PBMWriter(RAWBITS);
                } else if (subtype.equals(ImageFormat.IMAGE_FORMAT_PGM)) {
                    writer = new PGMWriter(RAWBITS);
                } else if (subtype.equals(ImageFormat.IMAGE_FORMAT_PPM)) {
                    writer = new PPMWriter(RAWBITS);
                }
            }
        }
        if (writer == null) {
            writer = new PPMWriter(RAWBITS);
        }
        if ((params = new Hashtable(params)).containsKey("FORMAT")) {
            params.remove("FORMAT");
        }
        if (params.size() > 0) {
            Object firstKey = params.keySet().iterator().next();
            throw new ImageWriteException("Unknown parameter: " + firstKey);
        }
        ((PNMWriter)writer).writeImage(src, os, params);
    }
}

