/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.tiff.datareaders;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.common.BinaryConstants;
import org.apache.sanselan.common.BitInputStream;
import org.apache.sanselan.common.PackBits;
import org.apache.sanselan.common.byteSources.ByteSource;
import org.apache.sanselan.common.mylzw.MyLZWDecompressor;
import org.apache.sanselan.formats.tiff.TiffConstants;
import org.apache.sanselan.formats.tiff.photometricinterpreters.PhotometricInterpreter;

public abstract class DataReader
implements TiffConstants,
BinaryConstants {
    protected final PhotometricInterpreter photometricInterpreter;
    protected final int[] bitsPerSample;
    protected final int[] last;
    protected final int predictor;
    protected final int samplesPerPixel;
    protected final int byteOrder;
    private int count = 0;

    public DataReader(PhotometricInterpreter fPhotometricInterpreter, int[] fBitsPerSample, int Predictor, int fSamplesPerPixel, int byteOrder) {
        this.photometricInterpreter = fPhotometricInterpreter;
        this.bitsPerSample = fBitsPerSample;
        this.samplesPerPixel = fSamplesPerPixel;
        this.predictor = Predictor;
        this.byteOrder = byteOrder;
        this.last = new int[fSamplesPerPixel];
    }

    public abstract void readImageData(BufferedImage var1, ByteSource var2) throws ImageReadException, IOException;

    protected int[] getSamplesAsBytes(BitInputStream bis) throws ImageReadException, IOException {
        int[] result = new int[this.bitsPerSample.length];
        for (int i = 0; i < this.bitsPerSample.length; ++i) {
            int bits = this.bitsPerSample[i];
            int sample = bis.readBits(bits);
            if (bits < 8) {
                int sign = sample & 1;
                sample <<= 8 - bits;
                if (sign > 0) {
                    sample |= (1 << 8 - bits) - 1;
                }
            } else if (bits > 8) {
                sample >>= bits - 8;
            }
            result[i] = sample;
        }
        return result;
    }

    protected int[] applyPredictor(int[] samples, int x) {
        if (this.predictor == 2) {
            for (int i = 0; i < samples.length; ++i) {
                if (x > 0) {
                    samples[i] = 0xFF & samples[i] + this.last[i];
                }
                this.last[i] = samples[i];
            }
        }
        return samples;
    }

    protected byte[] decompress(byte[] compressed, int compression, int expected_size) throws ImageReadException, IOException {
        switch (compression) {
            case 1: {
                return compressed;
            }
            case 2: {
                throw new ImageReadException("Tiff: unknown compression: " + compression);
            }
            case 5: {
                ByteArrayInputStream is = new ByteArrayInputStream(compressed);
                int LZWMinimumCodeSize = 8;
                MyLZWDecompressor fMyLzwDecompressor = new MyLZWDecompressor(LZWMinimumCodeSize, 77);
                fMyLzwDecompressor.setTiffLZWMode();
                byte[] result = fMyLzwDecompressor.decompress(is, expected_size);
                return result;
            }
            case 32773: {
                byte[] unpacked = new PackBits().decompress(compressed, expected_size);
                ++this.count;
                return unpacked;
            }
        }
        throw new ImageReadException("Tiff: unknown compression: " + compression);
    }
}

