/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.tiff.fieldtypes;

import org.apache.sanselan.ImageWriteException;
import org.apache.sanselan.common.BinaryFileFunctions;
import org.apache.sanselan.formats.tiff.TiffField;

public abstract class FieldType
extends BinaryFileFunctions {
    public final int type;
    public final int length;
    public final String name;

    public FieldType(int type, int length, String name) {
        this.type = type;
        this.length = length;
        this.name = name;
    }

    public boolean isLocalValue(TiffField entry) {
        return this.length > 0 && this.length * entry.length <= 4;
    }

    public String getDisplayValue(TiffField entry) {
        Object o = this.getSimpleValue(entry);
        if (o == null) {
            return "NULL";
        }
        return o.toString();
    }

    public final byte[] getRawBytes(TiffField entry) {
        if (this.isLocalValue(entry)) {
            return this.readBytearray(this.name, entry.valueOffsetBytes, 0, this.length * entry.length);
        }
        return entry.oversizeValue;
    }

    public abstract Object getSimpleValue(TiffField var1);

    public String toString() {
        return "[" + this.getClass().getName() + ". type: " + this.type + ", name: " + this.name + ", length: " + this.length + "]";
    }

    public abstract byte[] writeData(Object var1, int var2) throws ImageWriteException;
}

