/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.common.byteSources;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import org.apache.sanselan.common.byteSources.ByteSource;
import org.apache.sanselan.util.Debug;

public class ByteSourceFile
extends ByteSource {
    private final File file;

    public ByteSourceFile(File file) {
        super(file.getName());
        this.file = file;
    }

    public InputStream getInputStream() throws IOException {
        FileInputStream is = null;
        BufferedInputStream bis = null;
        is = new FileInputStream(this.file);
        bis = new BufferedInputStream(is);
        return bis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBlock(int start, int length) throws IOException {
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(this.file, "r");
            byte[] byArray = this.getRAFBytes(raf, start, length, "Could not read value from file");
            return byArray;
        }
        finally {
            try {
                raf.close();
            }
            catch (Exception e) {
                Debug.debug(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getAll() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        InputStream is = null;
        try {
            int read;
            is = new FileInputStream(this.file);
            is = new BufferedInputStream(is);
            byte[] buffer = new byte[1024];
            while ((read = is.read(buffer)) > 0) {
                baos.write(buffer, 0, read);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            try {
                if (null != is) {
                    is.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public String getDescription() {
        return "File: '" + this.file.getAbsolutePath() + "'";
    }
}

