/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.tiff;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Vector;
import org.apache.sanselan.FormatCompliance;
import org.apache.sanselan.ImageFormat;
import org.apache.sanselan.ImageInfo;
import org.apache.sanselan.ImageParser;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.ImageWriteException;
import org.apache.sanselan.common.IImageMetadata;
import org.apache.sanselan.common.byteSources.ByteSource;
import org.apache.sanselan.common.byteSources.ByteSourceArray;
import org.apache.sanselan.common.byteSources.ByteSourceFile;
import org.apache.sanselan.formats.tiff.RawTiffImageData;
import org.apache.sanselan.formats.tiff.TagInfo;
import org.apache.sanselan.formats.tiff.TiffConstants;
import org.apache.sanselan.formats.tiff.TiffContents;
import org.apache.sanselan.formats.tiff.TiffDirectory;
import org.apache.sanselan.formats.tiff.TiffField;
import org.apache.sanselan.formats.tiff.TiffHeader;
import org.apache.sanselan.formats.tiff.TiffImageMetadata;
import org.apache.sanselan.formats.tiff.datareaders.DataReader;
import org.apache.sanselan.formats.tiff.datareaders.DataReaderStrips;
import org.apache.sanselan.formats.tiff.datareaders.DataReaderTiled;
import org.apache.sanselan.formats.tiff.photometricinterpreters.PhotometricInterpreter;
import org.apache.sanselan.formats.tiff.photometricinterpreters.PhotometricInterpreterBiLevel;
import org.apache.sanselan.formats.tiff.photometricinterpreters.PhotometricInterpreterCIELAB;
import org.apache.sanselan.formats.tiff.photometricinterpreters.PhotometricInterpreterCMYK;
import org.apache.sanselan.formats.tiff.photometricinterpreters.PhotometricInterpreterLogLUV;
import org.apache.sanselan.formats.tiff.photometricinterpreters.PhotometricInterpreterPalette;
import org.apache.sanselan.formats.tiff.photometricinterpreters.PhotometricInterpreterRGB;
import org.apache.sanselan.formats.tiff.photometricinterpreters.PhotometricInterpreterYCbCr;
import org.apache.sanselan.formats.tiff.write.TiffImageWriter;
import org.apache.sanselan.util.Debug;

public class TiffImageParser
extends ImageParser
implements TiffConstants {
    private static final String DEFAULT_EXTENSION = ".tif";
    private static final String[] ACCEPTED_EXTENSIONS = new String[]{".tif", ".tiff"};
    private static final int TAG_ICC_PROFILE = 34675;

    public String getName() {
        return "Tiff-Custom";
    }

    public String getDefaultExtension() {
        return DEFAULT_EXTENSION;
    }

    protected String[] getAcceptedExtensions() {
        return ACCEPTED_EXTENSIONS;
    }

    protected ImageFormat[] getAcceptedTypes() {
        return new ImageFormat[]{ImageFormat.IMAGE_FORMAT_TIFF};
    }

    private TiffHeader readTiffHeader(InputStream is, FormatCompliance formatCompliance) throws ImageReadException, IOException {
        byte BYTE_ORDER_1 = this.readByte("BYTE_ORDER_1", is, "Not a Valid TIFF File");
        byte BYTE_ORDER_2 = this.readByte("BYTE_ORDER_2", is, "Not a Valid TIFF File");
        this.setByteOrder(BYTE_ORDER_1, BYTE_ORDER_2);
        int tiffVersion = this.read2Bytes("tiffVersion", is, "Not a Valid TIFF File");
        if (tiffVersion != 42) {
            throw new ImageReadException("Unknown Tiff Version: " + tiffVersion);
        }
        int offsetToFirstIFD = this.read4Bytes("offsetToFirstIFD", is, "Not a Valid TIFF File");
        this.skipBytes(is, offsetToFirstIFD - 8, "Not a Valid TIFF File: couldn't find IFDs");
        if (this.debug) {
            System.out.println("");
        }
        return new TiffHeader(BYTE_ORDER_1, tiffVersion, offsetToFirstIFD);
    }

    private boolean keepField(int Tag, int[] tags) {
        if (tags == null) {
            return true;
        }
        for (int i = 0; i < tags.length; ++i) {
            if (tags[i] != Tag) continue;
            return true;
        }
        return false;
    }

    private TiffDirectory readDirectory(InputStream is, int dirType, int offset, int[] tags, int maxEntriesToMatch) throws ImageReadException, IOException {
        Vector<TiffField> result = new Vector<TiffField>();
        int entryCount = this.read2Bytes("DirectoryEntryCount", is, "Not a Valid TIFF File");
        for (int i = 0; i < entryCount; ++i) {
            int tag = this.read2Bytes("Tag", is, "Not a Valid TIFF File");
            int type = this.read2Bytes("Type", is, "Not a Valid TIFF File");
            int length = this.read4Bytes("Length", is, "Not a Valid TIFF File");
            byte[] valueOffsetBytes = this.readByteArray("ValueOffset", 4, is, "Not a Valid TIFF File");
            int valueOffset = this.convertByteArrayToInt("ValueOffset", valueOffsetBytes);
            if (!this.keepField(tag, tags)) continue;
            TiffField entry = new TiffField(tag, type, length, valueOffset, valueOffsetBytes, this.getByteOrder());
            result.add(entry);
            if (this.debug) {
                for (int j = 0; j < 4; ++j) {
                    System.out.println("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
                }
            }
            if (maxEntriesToMatch <= 0 || result.size() < maxEntriesToMatch) continue;
            return new TiffDirectory(dirType, result, offset, -1);
        }
        int nextDirectoryOffset = this.read4Bytes("nextDirectoryOffset", is, "Not a Valid TIFF File");
        if (this.debug) {
            System.out.println("");
        }
        return new TiffDirectory(dirType, result, offset, nextDirectoryOffset);
    }

    private TiffContents readDirectories(ByteSource byteSource, int[] tags, FormatCompliance formatCompliance) throws ImageReadException, IOException {
        return this.readDirectories(byteSource, tags, -1, -1, formatCompliance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TiffContents readDirectories(ByteSource byteSource, int[] tags, int maxDirectoriesToRead, int maxEntriesToMatch, FormatCompliance formatCompliance) throws ImageReadException, IOException {
        TiffHeader tiffHeader;
        InputStream is = null;
        try {
            is = byteSource.getInputStream();
            tiffHeader = this.readTiffHeader(is, formatCompliance);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {
                Debug.debug(e);
            }
        }
        Vector<TiffDirectory> directories = new Vector<TiffDirectory>();
        int offset = tiffHeader.offsetToFirstIFD;
        int count = 0;
        while (offset > 0 && (maxDirectoriesToRead < 1 || directories.size() < maxDirectoriesToRead)) {
            int dirType = 0 == count ? 1 : 2;
            TiffDirectory directory = this.readSingleDirectory(byteSource, dirType, offset, formatCompliance);
            if (directory.entries.size() > 0) {
                directories.add(directory);
            }
            offset = directory.nextDirectoryOffset;
            ++count;
        }
        return new TiffContents(tiffHeader, directories);
    }

    private TiffDirectory readSingleDirectory(ByteSource byteSource, int dirType, int offset, FormatCompliance formatCompliance) throws ImageReadException, IOException {
        int[] tags = null;
        int maxEntriesToMatch = -1;
        return this.readSingleDirectory(byteSource, dirType, offset, tags, maxEntriesToMatch, formatCompliance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TiffDirectory readSingleDirectory(ByteSource byteSource, int dirType, int offset, int[] tags, int maxEntriesToMatch, FormatCompliance formatCompliance) throws ImageReadException, IOException {
        InputStream is = null;
        try {
            is = byteSource.getInputStream();
            if (offset > 0) {
                is.skip(offset);
            }
            TiffDirectory directory = this.readDirectory(is, dirType, offset, tags, maxEntriesToMatch);
            directory.fillInValues(byteSource);
            TiffDirectory tiffDirectory = directory;
            return tiffDirectory;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {
                Debug.debug(e);
            }
        }
    }

    public byte[] getICCProfileBytes(ByteSource byteSource) throws ImageReadException, IOException {
        int[] FieldTypes = new int[]{34675};
        TiffContents contents = this.readDirectories(byteSource, FieldTypes, -1, 1, this.getDefaultFormatCompliance());
        if (contents == null) {
            throw new ImageReadException("TIFF missing contents");
        }
        Vector directories = contents.directories;
        if (directories == null || directories.size() < 1) {
            return null;
        }
        TiffDirectory directory = (TiffDirectory)directories.get(0);
        Vector entries = directory.entries;
        if (entries == null || entries.size() != 1) {
            throw new ImageReadException("TIFF missing entries");
        }
        TiffField de = (TiffField)entries.get(0);
        byte[] bytes = de.oversizeValue;
        return bytes;
    }

    private TiffField findField(Vector directories, int tag) throws ImageReadException, IOException {
        if (directories == null || directories.size() < 1) {
            throw new ImageReadException("TIFF missing directories");
        }
        TiffDirectory directory = (TiffDirectory)directories.get(0);
        Vector entries = directory.entries;
        if (entries == null || entries.size() < 1) {
            throw new ImageReadException("TIFF missing entries");
        }
        for (int i = 0; i < entries.size(); ++i) {
            TiffField field = (TiffField)entries.get(i);
            if (field.tag != tag) continue;
            return field;
        }
        return null;
    }

    private TiffField findField(Vector entries, TagInfo tag) {
        if (entries == null) {
            return null;
        }
        for (int i = 0; i < entries.size(); ++i) {
            TiffField field = (TiffField)entries.get(i);
            if (field.tag != tag.tag) continue;
            return field;
        }
        return null;
    }

    public Dimension getImageSize(ByteSource byteSource) throws ImageReadException, IOException {
        int[] fieldTypes = new int[]{TiffImageParser.TIFF_TAG_ImageWidth.tag, TiffImageParser.TIFF_TAG_ImageLength.tag};
        TiffContents contents = this.readDirectories(byteSource, fieldTypes, -1, 2, this.getDefaultFormatCompliance());
        if (contents == null) {
            throw new ImageReadException("TIFF missing contents");
        }
        Vector directories = contents.directories;
        TiffField widthField = this.findField(directories, TiffImageParser.TIFF_TAG_ImageWidth.tag);
        TiffField heightField = this.findField(directories, TiffImageParser.TIFF_TAG_ImageLength.tag);
        if (widthField == null || heightField == null) {
            throw new ImageReadException("TIFF image has invalid size.");
        }
        Number width = (Number)widthField.getValue();
        Number height = (Number)heightField.getValue();
        if (width == null || height == null) {
            throw new ImageReadException("TIFF image missing size info.");
        }
        return new Dimension(width.intValue(), height.intValue());
    }

    public byte[] embedICCProfile(byte[] image, byte[] profile) {
        return null;
    }

    public boolean embedICCProfile(File src, File dst, byte[] profile) {
        return false;
    }

    public TiffContents readDirectories(byte[] bytes) throws ImageReadException, IOException {
        return this.readDirectories(new ByteSourceArray(bytes), null, this.getDefaultFormatCompliance());
    }

    public TiffContents readDirectories(File file) throws ImageReadException, IOException {
        return this.readDirectories(new ByteSourceFile(file), null, this.getDefaultFormatCompliance());
    }

    private boolean readThumbnails(Map params) {
        if (params == null) {
            return false;
        }
        Object o = params.get("READ_THUMBNAILS");
        if (o == null) {
            return false;
        }
        if (!(o instanceof Boolean)) {
            return false;
        }
        return o.equals(Boolean.TRUE);
    }

    public IImageMetadata getMetadata(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        TiffContents contents = this.readDirectories(byteSource, null, this.getDefaultFormatCompliance());
        if (contents == null) {
            throw new ImageReadException("TIFF missing contents");
        }
        Vector directories = contents.directories;
        TiffImageMetadata result = new TiffImageMetadata(contents);
        for (int i = 0; i < directories.size(); ++i) {
            TiffDirectory dir = (TiffDirectory)directories.get(i);
            TiffImageMetadata.Directory metadataDirectory = new TiffImageMetadata.Directory(dir);
            if (this.readThumbnails(params)) {
                if (dir.hasTiffImageData()) {
                    BufferedImage thumbnail = this.getBufferedImage(byteSource, dir, null);
                    metadataDirectory.setThumbnail(thumbnail);
                    RawTiffImageData rawImageData = this.getTiffRawImageData(byteSource, dir);
                    metadataDirectory.setRawTiffImageData(rawImageData);
                }
                if (dir.hasJpegImageData()) {
                    byte[] rawJpegImageData = this.getJpegRawImageData(byteSource, dir);
                    metadataDirectory.setRawJpegImageData(rawJpegImageData);
                }
            }
            Vector entries = dir.getDirectoryEntrys();
            for (int j = 0; j < entries.size(); ++j) {
                TiffField entry = (TiffField)entries.get(j);
                if (entry.tag == TiffConstants.TIFF_TAG_Exif_IFD_Pointer.tag || entry.tag == TiffConstants.TIFF_TAG_GPSInfo_IFD_Pointer.tag || entry.tag == TiffConstants.TIFF_TAG_Interoperability_IFD_Pointer.tag) {
                    int dirType;
                    int offset = ((Number)entry.getValue()).intValue();
                    if (entry.tag == TiffConstants.TIFF_TAG_Exif_IFD_Pointer.tag) {
                        dirType = 4;
                    } else if (entry.tag == TiffConstants.TIFF_TAG_GPSInfo_IFD_Pointer.tag) {
                        dirType = 6;
                    } else if (entry.tag == TiffConstants.TIFF_TAG_Interoperability_IFD_Pointer.tag) {
                        dirType = 7;
                    } else {
                        throw new ImageReadException("Unknown subdirectory type.");
                    }
                    TiffDirectory extraDir = this.readSingleDirectory(byteSource, dirType, offset, this.getDefaultFormatCompliance());
                    directories.insertElementAt(extraDir, i + 1);
                }
                metadataDirectory.add(entry);
            }
            result.add(metadataDirectory);
        }
        return result;
    }

    private double[] getValueAsDoubleArray(TiffField field) {
        if (field == null) {
            return null;
        }
        Object o = field.getValue();
        if (o == null) {
            return null;
        }
        if (o instanceof Number) {
            return new double[]{((Number)o).doubleValue()};
        }
        if (o instanceof Number[]) {
            Number[] numbers = (Number[])o;
            double[] result = new double[numbers.length];
            for (int i = 0; i < numbers.length; ++i) {
                result[i] = numbers[i].doubleValue();
            }
            return result;
        }
        if (o instanceof int[]) {
            int[] numbers = (int[])o;
            double[] result = new double[numbers.length];
            for (int i = 0; i < numbers.length; ++i) {
                result[i] = numbers[i];
            }
            return result;
        }
        if (o instanceof float[]) {
            float[] numbers = (float[])o;
            double[] result = new double[numbers.length];
            for (int i = 0; i < numbers.length; ++i) {
                result[i] = numbers[i];
            }
            return result;
        }
        if (o instanceof double[]) {
            double[] numbers = (double[])o;
            double[] result = new double[numbers.length];
            for (int i = 0; i < numbers.length; ++i) {
                result[i] = numbers[i];
            }
            return result;
        }
        return null;
    }

    private int[] getValueAsIntArray(TiffField field) {
        if (field == null) {
            return null;
        }
        Object o = field.getValue();
        if (o == null) {
            return null;
        }
        if (o instanceof Number) {
            return new int[]{((Number)o).intValue()};
        }
        if (o instanceof Number[]) {
            Number[] numbers = (Number[])o;
            int[] result = new int[numbers.length];
            for (int i = 0; i < numbers.length; ++i) {
                result[i] = numbers[i].intValue();
            }
            return result;
        }
        if (o instanceof int[]) {
            int[] numbers = (int[])o;
            int[] result = new int[numbers.length];
            for (int i = 0; i < numbers.length; ++i) {
                result[i] = numbers[i];
            }
            return result;
        }
        return null;
    }

    private int getValueOrArraySum(TiffField field) {
        if (field == null) {
            return -1;
        }
        Object o = field.getValue();
        if (o == null) {
            return -1;
        }
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        if (o instanceof Number[]) {
            Number[] numbers = (Number[])o;
            int sum = 0;
            for (int i = 0; i < numbers.length; ++i) {
                sum += numbers[i].intValue();
            }
            return sum;
        }
        if (o instanceof int[]) {
            int[] numbers = (int[])o;
            int sum = 0;
            for (int i = 0; i < numbers.length; ++i) {
                sum += numbers[i];
            }
            return sum;
        }
        return -1;
    }

    public ImageInfo getImageInfo(ByteSource byteSource) throws ImageReadException, IOException {
        String compressionAlgorithm;
        int[] FieldTypes = new int[]{TiffImageParser.TIFF_TAG_ImageWidth.tag, TiffImageParser.TIFF_TAG_ImageLength.tag, TiffImageParser.TIFF_TAG_ResolutionUnit.tag, TiffImageParser.TIFF_TAG_XResolution.tag, TiffImageParser.TIFF_TAG_YResolution.tag, TiffImageParser.TIFF_TAG_BitsPerSample.tag, TiffImageParser.TIFF_TAG_ColorMap.tag, TiffImageParser.TIFF_TAG_SamplesPerPixel.tag, TiffImageParser.TIFF_TAG_Compression.tag};
        TiffContents contents = this.readDirectories(byteSource, FieldTypes, -1, -1, this.getDefaultFormatCompliance());
        if (contents == null) {
            throw new ImageReadException("TIFF missing contents");
        }
        Vector dirs = contents.directories;
        if (dirs == null || dirs.size() < 1) {
            throw new ImageReadException("TIFF image missing directories");
        }
        TiffDirectory directory = (TiffDirectory)dirs.get(0);
        Vector entries = directory.entries;
        if (entries == null) {
            throw new ImageReadException("TIFF missing entries");
        }
        TiffField widthField = this.findField(entries, TIFF_TAG_ImageWidth);
        TiffField heightField = this.findField(entries, TIFF_TAG_ImageLength);
        if (widthField == null || heightField == null) {
            throw new ImageReadException("TIFF image missing size info.");
        }
        int height = ((Number)heightField.getValue()).intValue();
        int width = ((Number)widthField.getValue()).intValue();
        TiffField resolutionUnitField = this.findField(entries, TIFF_TAG_ResolutionUnit);
        int resolutionUnit = 2;
        if (resolutionUnitField != null && resolutionUnitField.getValue() != null) {
            resolutionUnit = ((Number)resolutionUnitField.getValue()).intValue();
        }
        double unitsPerInch = -1.0;
        switch (resolutionUnit) {
            case 1: {
                break;
            }
            case 2: {
                unitsPerInch = 1.0;
                break;
            }
            case 3: {
                unitsPerInch = 0.0254;
                break;
            }
        }
        TiffField xResolutionField = this.findField(entries, TIFF_TAG_XResolution);
        TiffField yResolutionField = this.findField(entries, TIFF_TAG_YResolution);
        int physicalWidthDpi = -1;
        float physicalWidthInch = -1.0f;
        int physicalHeightDpi = -1;
        float physicalHeightInch = -1.0f;
        if (unitsPerInch > 0.0) {
            if (xResolutionField != null && xResolutionField.getValue() != null) {
                double XResolutionPixelsPerUnit = ((Number)xResolutionField.getValue()).doubleValue();
                physicalWidthDpi = (int)(XResolutionPixelsPerUnit / unitsPerInch);
                physicalWidthInch = (float)((double)width / (XResolutionPixelsPerUnit * unitsPerInch));
            }
            if (yResolutionField != null && yResolutionField.getValue() != null) {
                double YResolutionPixelsPerUnit = ((Number)yResolutionField.getValue()).doubleValue();
                physicalHeightDpi = (int)(YResolutionPixelsPerUnit / unitsPerInch);
                physicalHeightInch = (float)((double)height / (YResolutionPixelsPerUnit * unitsPerInch));
            }
        }
        TiffField bitsPerSampleField = this.findField(entries, TIFF_TAG_BitsPerSample);
        int bitsPerSample = -1;
        if (bitsPerSampleField != null && bitsPerSampleField.getValue() != null) {
            bitsPerSample = this.getValueOrArraySum(bitsPerSampleField);
        }
        int bitsPerPixel = bitsPerSample;
        Vector<String> comments = new Vector<String>();
        for (int i = 0; i < entries.size(); ++i) {
            TiffField field = (TiffField)entries.get(i);
            String comment = field.toString();
            comments.add(comment);
        }
        ImageFormat format = ImageFormat.IMAGE_FORMAT_TIFF;
        String formatName = "TIFF Tag-based Image File Format";
        String mimeType = "image/tiff";
        int numberOfImages = -1;
        boolean isProgressive = false;
        String formatDetails = "Tiff v." + contents.header.tiffVersion;
        boolean isTransparent = false;
        boolean usesPalette = false;
        TiffField colorMapField = this.findField(entries, TIFF_TAG_ColorMap);
        if (colorMapField != null) {
            usesPalette = true;
        }
        int colorType = 2;
        int compression = this.getTagAsNumber(entries, TIFF_TAG_Compression).intValue();
        switch (compression) {
            case 1: {
                compressionAlgorithm = "None";
                break;
            }
            case 2: {
                compressionAlgorithm = "CCITT 1D";
                break;
            }
            case 3: {
                compressionAlgorithm = "CCITT Group 3 1-Dimensional Modified Huffman run-length encoding.";
                break;
            }
            case 4: {
                compressionAlgorithm = "CCITT Group 4";
                break;
            }
            case 5: {
                compressionAlgorithm = "LZW";
                break;
            }
            case 6: {
                compressionAlgorithm = "JPEG";
                break;
            }
            case 32771: {
                compressionAlgorithm = "None";
                break;
            }
            case 32773: {
                compressionAlgorithm = "PackBits";
                break;
            }
            default: {
                compressionAlgorithm = "Unknown";
            }
        }
        ImageInfo result = new ImageInfo(formatDetails, bitsPerPixel, comments, format, formatName, height, mimeType, numberOfImages, physicalHeightDpi, physicalHeightInch, physicalWidthDpi, physicalWidthInch, width, isProgressive, isTransparent, usesPalette, colorType, compressionAlgorithm);
        return result;
    }

    public boolean dumpImageFile(PrintWriter pw, ByteSource byteSource) throws ImageReadException, IOException {
        pw.println("tiff.dumpImageFile");
        ImageInfo imageData = this.getImageInfo(byteSource);
        if (imageData == null) {
            return false;
        }
        imageData.toString(pw, "");
        pw.println("");
        try {
            TiffContents contents = this.readDirectories(byteSource, null, -1, -1, this.getDefaultFormatCompliance());
            if (contents == null) {
                return false;
            }
            Vector directories = contents.directories;
            if (directories == null) {
                return false;
            }
            for (int d = 0; d < directories.size(); ++d) {
                TiffDirectory directory = (TiffDirectory)directories.get(d);
                Vector entries = directory.entries;
                if (entries == null) {
                    return false;
                }
                Debug.debug("directory offset", directory.offset);
                Debug.debug("directory offset", directory.offset);
                for (int i = 0; i < entries.size(); ++i) {
                    TiffField field = (TiffField)entries.get(i);
                    field.dump(pw, d + "");
                }
            }
            pw.println("");
        }
        catch (Exception e) {
            Debug.debug(e);
            pw.println("");
            return false;
        }
        return true;
    }

    private Number getTagAsNumber(Vector entries, TagInfo tag) throws ImageReadException, IOException {
        TiffField entry = this.findField(entries, tag);
        if (entry == null) {
            throw new ImageReadException("Tiff: Missing Tag: " + tag.name + " (" + tag.tag + ")");
        }
        Object o = entry.getValue();
        Number result = (Number)o;
        if (this.debug) {
            this.debugNumber(tag.name + " (" + tag.tag + ")", result.intValue(), 4);
        }
        return result;
    }

    private int getTagAsValueOrArraySum(Vector entries, TagInfo tag) throws ImageReadException, IOException {
        TiffField entry = this.findField(entries, tag);
        if (entry == null) {
            throw new ImageReadException("Tiff: Missing Tag: " + tag.name + " (" + tag.tag + ")");
        }
        int result = this.getValueOrArraySum(entry);
        if (this.debug) {
            this.debugNumber(tag.name + " (" + tag.tag + ")", result, 4);
        }
        return result;
    }

    private double[] getTagAsDoubleArray(Vector entries, TagInfo tag, boolean throwExceptionIfMissing) throws ImageReadException, IOException {
        TiffField entry = this.findField(entries, tag);
        if (entry == null) {
            if (throwExceptionIfMissing) {
                throw new ImageReadException("Tiff: Missing Tag: " + tag.name + " (" + tag.tag + ")");
            }
            return null;
        }
        double[] result = this.getValueAsDoubleArray(entry);
        return result;
    }

    private int[] getTagAsIntArray(Vector entries, TagInfo tag, boolean throwExceptionIfMissing) throws ImageReadException, IOException {
        TiffField entry = this.findField(entries, tag);
        if (entry == null) {
            if (throwExceptionIfMissing) {
                throw new ImageReadException("Tiff: Missing Tag: " + tag.name + " (" + tag.tag + ")");
            }
            return null;
        }
        int[] result = this.getValueAsIntArray(entry);
        if (this.debug) {
            this.debugNumberArray(tag.name + " (" + tag.tag + ")", result, 4);
        }
        return result;
    }

    private int dumpOptionalNumberTag(Vector entries, TagInfo tag) {
        Object o;
        TiffField entry = this.findField(entries, tag);
        if (entry != null && (o = entry.getValue()) instanceof Number) {
            int value = ((Number)o).intValue();
            if (this.debug) {
                System.out.println(tag.name + ": " + value);
            }
            return value;
        }
        return -1;
    }

    public FormatCompliance getFormatCompliance(ByteSource byteSource) throws ImageReadException, IOException {
        FormatCompliance result = new FormatCompliance(byteSource.getDescription());
        this.readDirectories(byteSource, null, -1, -1, result);
        return result;
    }

    public BufferedImage getBufferedImage(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        TiffContents contents = this.readDirectories(byteSource, null, -1, -1, this.getDefaultFormatCompliance());
        if (contents == null) {
            throw new ImageReadException("TIFF missing contents");
        }
        Vector directories = contents.directories;
        if (directories == null || directories.size() < 1) {
            throw new ImageReadException("TIFF missing TiffDirectories");
        }
        TiffDirectory directory = (TiffDirectory)directories.get(0);
        return this.getBufferedImage(byteSource, directory, params);
    }

    public RawTiffImageData getTiffRawImageData(ByteSource byteSource, TiffDirectory directory) throws ImageReadException, IOException {
        Vector elements = directory.getTiffRawImageDataElements();
        byte[][] result = new byte[elements.size()][];
        for (int i = 0; i < elements.size(); ++i) {
            TiffDirectory.ImageDataElement element = (TiffDirectory.ImageDataElement)elements.get(i);
            result[i] = byteSource.getBlock(element.offset, element.length);
        }
        if (directory.imageDataInStrips()) {
            return new RawTiffImageData.Strips(result);
        }
        return new RawTiffImageData.Tiles(result);
    }

    public byte[] getJpegRawImageData(ByteSource byteSource, TiffDirectory directory) throws ImageReadException, IOException {
        TiffDirectory.ImageDataElement element = directory.getJpegRawImageDataElement();
        byte[] result = byteSource.getBlock(element.offset, element.length);
        return result;
    }

    public BufferedImage getBufferedImage(ByteSource byteSource, TiffDirectory directory, Map params) throws ImageReadException, IOException {
        Vector entries = directory.entries;
        if (entries == null) {
            throw new ImageReadException("TIFF missing entries");
        }
        TiffField imageWidthField = this.findField(entries, TIFF_TAG_ImageWidth);
        if (imageWidthField == null) {
            throw new ImageReadException("Tiff: Missing Tag: TIFF_TAG_ImageWidth");
        }
        TiffField imageLengthField = this.findField(entries, TIFF_TAG_ImageLength);
        if (imageLengthField == null) {
            throw new ImageReadException("Tiff: Missing Tag: TIFF_TAG_ImageLength");
        }
        int photometricInterpretation = this.getTagAsNumber(entries, TIFF_TAG_PhotometricInterpretation).intValue();
        int compression = this.getTagAsNumber(entries, TIFF_TAG_Compression).intValue();
        int width = this.getTagAsNumber(entries, TIFF_TAG_ImageWidth).intValue();
        int height = this.getTagAsNumber(entries, TIFF_TAG_ImageLength).intValue();
        int samplesPerPixel = this.getTagAsNumber(entries, TIFF_TAG_SamplesPerPixel).intValue();
        int[] bitsPerSample = this.getTagAsIntArray(entries, TIFF_TAG_BitsPerSample, true);
        int bitsPerPixel = this.getTagAsValueOrArraySum(entries, TIFF_TAG_BitsPerSample);
        this.dumpOptionalNumberTag(entries, TIFF_TAG_FillOrder);
        this.dumpOptionalNumberTag(entries, TIFF_TAG_FreeByteCounts);
        this.dumpOptionalNumberTag(entries, TIFF_TAG_FreeOffsets);
        this.dumpOptionalNumberTag(entries, TIFF_TAG_Orientation);
        this.dumpOptionalNumberTag(entries, TIFF_TAG_PlanarConfiguration);
        int predictor = this.dumpOptionalNumberTag(entries, TIFF_TAG_Predictor);
        if (samplesPerPixel != bitsPerSample.length) {
            throw new ImageReadException("Tiff: fSamplesPerPixel (" + samplesPerPixel + ")!=fBitsPerSample.length (" + bitsPerSample.length + ")");
        }
        boolean hasAlpha = false;
        BufferedImage result = this.getBufferedImageFactory(params).getColorBufferedImage(width, height, hasAlpha);
        PhotometricInterpreter photometricInterpreter = this.getPhotometricInterpreter(entries, photometricInterpretation, bitsPerPixel, bitsPerSample, predictor, samplesPerPixel, width, height);
        DataReader dataReader = this.getDataReader(entries, photometricInterpreter, bitsPerPixel, bitsPerSample, predictor, samplesPerPixel, width, height, compression);
        dataReader.readImageData(result, byteSource);
        photometricInterpreter.dumpstats();
        return result;
    }

    private PhotometricInterpreter getPhotometricInterpreter(Vector entries, int photometricInterpretation, int bitsPerPixel, int[] bitsPerSample, int predictor, int samplesPerPixel, int width, int height) throws IOException, ImageReadException {
        switch (photometricInterpretation) {
            case 0: 
            case 1: {
                boolean invert = photometricInterpretation == 0;
                return new PhotometricInterpreterBiLevel(bitsPerPixel, samplesPerPixel, bitsPerSample, predictor, width, height, invert);
            }
            case 3: {
                int[] colorMap = this.getTagAsIntArray(entries, TIFF_TAG_ColorMap, false);
                int expected_colormap_size = 3 * (1 << bitsPerPixel);
                if (colorMap.length != expected_colormap_size) {
                    throw new ImageReadException("Tiff: fColorMap.length (" + colorMap.length + ")!=expected_colormap_size (" + expected_colormap_size + ")");
                }
                return new PhotometricInterpreterPalette(samplesPerPixel, bitsPerSample, predictor, width, height, colorMap);
            }
            case 2: {
                return new PhotometricInterpreterRGB(samplesPerPixel, bitsPerSample, predictor, width, height);
            }
            case 5: {
                return new PhotometricInterpreterCMYK(samplesPerPixel, bitsPerSample, predictor, width, height);
            }
            case 6: {
                double[] fYCbCrCoefficients = this.getTagAsDoubleArray(entries, TIFF_TAG_YCbCrCoefficients, false);
                int[] fYCbCrPositioning = this.getTagAsIntArray(entries, TIFF_TAG_YCbCrPositioning, false);
                int[] fYCbCrSubSampling = this.getTagAsIntArray(entries, TIFF_TAG_YCbCrSubSampling, false);
                double[] referenceBlackWhite = this.getTagAsDoubleArray(entries, TIFF_TAG_ReferenceBlackWhite, false);
                return new PhotometricInterpreterYCbCr(fYCbCrCoefficients, fYCbCrPositioning, fYCbCrSubSampling, referenceBlackWhite, samplesPerPixel, bitsPerSample, predictor, width, height);
            }
            case 8: {
                return new PhotometricInterpreterCIELAB(samplesPerPixel, bitsPerSample, predictor, width, height);
            }
            case 32844: 
            case 32845: {
                boolean yonly = photometricInterpretation == 32844;
                return new PhotometricInterpreterLogLUV(samplesPerPixel, bitsPerSample, predictor, width, height, yonly);
            }
        }
        throw new ImageReadException("TIFF: Unknown fPhotometricInterpretation: " + photometricInterpretation);
    }

    private DataReader getDataReader(Vector entries, PhotometricInterpreter photometricInterpreter, int bitsPerPixel, int[] bitsPerSample, int predictor, int samplesPerPixel, int width, int height, int compression) throws IOException, ImageReadException {
        int[] tileOffsets = this.getTagAsIntArray(entries, TIFF_TAG_TileOffsets, false);
        int[] tileByteCounts = this.getTagAsIntArray(entries, TIFF_TAG_TileByteCounts, false);
        int[] stripOffsets = this.getTagAsIntArray(entries, TIFF_TAG_StripOffsets, false);
        int[] stripByteCounts = this.getTagAsIntArray(entries, TIFF_TAG_StripByteCounts, false);
        TiffField tileWidthField = this.findField(entries, TIFF_TAG_TileWidth);
        TiffField tileLengthField = this.findField(entries, TIFF_TAG_TileLength);
        if (tileOffsets != null && tileByteCounts != null) {
            if (tileOffsets.length != tileByteCounts.length) {
                throw new ImageReadException("Tiff: fTileOffsets.length (" + tileOffsets.length + ")!=fTileByteCounts.length (" + tileByteCounts.length + ")");
            }
            int tileWidth = this.getTagAsNumber(entries, TIFF_TAG_TileWidth).intValue();
            int tileLength = this.getTagAsNumber(entries, TIFF_TAG_TileLength).intValue();
            return new DataReaderTiled(photometricInterpreter, tileOffsets, tileByteCounts, tileWidth, tileLength, bitsPerPixel, bitsPerSample, predictor, samplesPerPixel, width, height, compression, this.getByteOrder());
        }
        if (tileWidthField != null && tileLengthField != null && stripOffsets != null && stripByteCounts != null) {
            if (stripOffsets.length != stripByteCounts.length) {
                throw new ImageReadException("Tiff: fStripOffsets.length (" + stripOffsets.length + ")!=fStripByteCounts.length (" + stripByteCounts.length + ")");
            }
            int tileWidth = this.getTagAsNumber(entries, TIFF_TAG_TileWidth).intValue();
            int tileLength = this.getTagAsNumber(entries, TIFF_TAG_TileLength).intValue();
            return new DataReaderTiled(photometricInterpreter, stripOffsets, stripByteCounts, tileWidth, tileLength, bitsPerPixel, bitsPerSample, predictor, samplesPerPixel, width, height, compression, this.getByteOrder());
        }
        if (stripOffsets != null && stripByteCounts != null) {
            int rowsPerStrip = this.getTagAsNumber(entries, TIFF_TAG_RowsPerStrip).intValue();
            if (stripOffsets.length != stripByteCounts.length) {
                throw new ImageReadException("Tiff: fStripOffsets.length (" + stripOffsets.length + ")!=fStripByteCounts.length (" + stripByteCounts.length + ")");
            }
            return new DataReaderStrips(photometricInterpreter, bitsPerPixel, bitsPerSample, predictor, samplesPerPixel, width, height, stripOffsets, stripByteCounts, compression, rowsPerStrip, this.getByteOrder());
        }
        throw new ImageReadException("Tiff: Neither Strip nor Tile.");
    }

    public void writeImage(BufferedImage src, OutputStream os, Map params) throws ImageWriteException, IOException {
        new TiffImageWriter().writeImage(src, os, params);
    }
}

