package com.commons;

import java.util.Random;

import org.anddev.andengine.engine.Engine;
import org.anddev.andengine.engine.handler.physics.PhysicsHandler;
import org.anddev.andengine.entity.scene.Scene;
import org.anddev.andengine.entity.sprite.AnimatedSprite;
import org.anddev.andengine.input.touch.TouchEvent;
import org.anddev.andengine.opengl.texture.region.TiledTextureRegion;
import org.anddev.andengine.ui.activity.BaseGameActivity;

import android.util.Log;

public class game_object extends AnimatedSprite{

	//****************************************************************
	//** Propiedades estandar de objeto de juego
	//****************************************************************
	
	public int oid;
    public int orotation_angle=0; 
	
	//****************************************************************
	//** Propiedades de Imagen i textura
	//****************************************************************
	
	// Tamao de Sprite Map especifico para este objeto
	public int oTilesWith;
	public int oTilesHeight;
	public int oTilesRow;
	public int oTilesColumn;
	public String oFilePath;
	
	// Textura especial que contiene los Tiles para el AnimatedSprite
	public TiledTextureRegion oTiledTextureRegion;
	private PhysicsHandler physicsHandler;
	
	//****************************************************************
	//** Pixel-Perfect Collisions stuff
	//****************************************************************
	
	// Vector de vectores para los RGB DataColor
	public game_RGBColor[] oTileColorData; 

	
	
	//****************************************************************
	//** Misc
	//****************************************************************
	
	// Propiedadesn de acceso al Main
	private BaseGameActivity oactivity;
	private Engine oEngine;
    
    // Variables de tiempo
    private long startTime = System.currentTimeMillis();
    
	// DEL : Random de prueba
	private Random rand = new Random();
	
	public game_object(float pX, float pY, TiledTextureRegion pTiledTextureRegion,BaseGameActivity act_temp,int tid,Engine tEngine,int tTilesWith,int tTilesHeight,int tTilesRow,int tTilesColumn,String tFilePath) 
	{
		// Estamos llamando al constructor de la classe Padre. NO LOS CONSTRUCTORES NO SE HEREDAN
		super(pX, pY, pTiledTextureRegion);
		
		this.oid=tid;
		this.oTilesWith=tTilesWith;
		this.oTilesHeight=tTilesHeight;
		this.oTilesRow=tTilesRow;
		this.oTilesColumn=tTilesColumn;
		this.oFilePath=tFilePath;
		
		this.oTiledTextureRegion=pTiledTextureRegion;

		this.oactivity=act_temp;
		this.oEngine=tEngine;
		
	    physicsHandler = new PhysicsHandler(this);
	    this.registerUpdateHandler(physicsHandler);
	    physicsHandler.setVelocity(rand.nextInt(150), rand.nextInt(150));
	}

	// Evento que desencadema en el metodo constructor (movimiento del objeto sin tocar nada)
	// Iteracion en classe
	@Override
    protected void onManagedUpdate(final float pSecondsElapsed) {
		
            if(this.mX < 0) 
            {
                    this.physicsHandler.setVelocityX(rand.nextInt(150));
            } else if(this.mX + this.getWidth() > game_commons.cCamera_width) {
                    this.physicsHandler.setVelocityX(-rand.nextInt(150));
            }

            if(this.mY < 0) {
                    this.physicsHandler.setVelocityY(rand.nextInt(150));
            } else if(this.mY + this.getHeight() > game_commons.cCamera_height) {
                    this.physicsHandler.setVelocityY(-rand.nextInt(150));
            }
            
            //Arrancamos la animacion
            // Al fer la animacio es long per cada tile/imatge el seu temps , inici , fi ,true
            if (!this.isAnimationRunning()){this.animate(new long[]{100,100,100,100,100},1,5,true);}
            //this.stopAnimation(5);  -- > Para la animacion en la tile 5
            //game_commons.fv=this.getCurrentTileIndex();
            
            // OK rotacion en funcion del tiempo
            if (System.currentTimeMillis() - startTime >= 30) {
            	 // Vamos a hacer la rotacion
                if (orotation_angle>=360) orotation_angle=0;
                orotation_angle=orotation_angle+5;
                this.setRotation(orotation_angle);
                startTime = System.currentTimeMillis();
            }
            
            super.onManagedUpdate(pSecondsElapsed);
    }
	
	// Evento que desencadema cuando tocamos el objeto
	@Override
	public boolean onAreaTouched(final TouchEvent pSceneTouchEvent, final float pTouchAreaLocalX, final float pTouchAreaLocalY) 
	{
		game_commons.z++;
		this.setZIndex(game_commons.z);
		this.setPosition(pSceneTouchEvent.getX() - this.getWidth() / 2, pSceneTouchEvent.getY() - this.getHeight() / 2);
		Log.i("TEST_ACT", "obj1 touch");
		
		// Si me has marcado reordena otra vez el zindex
		final Scene scene = this.oEngine.getScene();
		scene.getLastChild().sortChildren();
		
		return true;
	}
	
}


