package com.commons;

import java.util.ArrayList;
import java.util.List;

import org.anddev.andengine.engine.Engine;
import org.anddev.andengine.entity.layer.tiled.tmx.TMXLayer;
import org.anddev.andengine.entity.layer.tiled.tmx.TMXLoader;
import org.anddev.andengine.entity.layer.tiled.tmx.TMXProperties;
import org.anddev.andengine.entity.layer.tiled.tmx.TMXTile;
import org.anddev.andengine.entity.layer.tiled.tmx.TMXTileProperty;
import org.anddev.andengine.entity.layer.tiled.tmx.TMXTiledMap;
import org.anddev.andengine.entity.layer.tiled.tmx.TMXLoader.ITMXTilePropertiesListener;
import org.anddev.andengine.entity.layer.tiled.tmx.util.exception.TMXLoadException;
import org.anddev.andengine.entity.text.ChangeableText;
import org.anddev.andengine.opengl.font.Font;
import org.anddev.andengine.opengl.texture.Texture;
import org.anddev.andengine.opengl.texture.TextureOptions;
import org.anddev.andengine.opengl.texture.region.TextureRegionFactory;
import org.anddev.andengine.opengl.texture.region.TiledTextureRegion;
import org.anddev.andengine.ui.activity.BaseGameActivity;

import android.graphics.Color;
import android.graphics.Typeface;

public class game_commons {
	
	private static final int sprite_map_with=256;
	private static final int sprite_map_height=256;
	
	// Creamos variables para definir sobre que resolucion vamos a trabajar 
	public static int cCamera_width = 480;
	public static int cCamera_height = 320;
	
	// TAG que vamos a usar para los mensajes de Log que estan en DEBUG
	public static String cTag = "AndEngineTest";
	
	// *** TEST 
	public static int z=1;
	
	// Texto de Status 
	private static Texture cStatus_FontTexture;
	private static Font cStatus_t;
	public static ChangeableText cStatus;

	public static float cVelocity = 100.0f;
	
	// Sprite Map al que concatenamos imagenes
	public static Texture cSpriteMap = new Texture(sprite_map_with, sprite_map_height,TextureOptions.BILINEAR_PREMULTIPLYALPHA);
	
	// Lista de objetos de juego
	public static List<game_object> objects = new ArrayList<game_object>();

	// DEL : Test
	public static String fv; 
	
	public static TiledTextureRegion loadToSpriteMap(String tpath,int initial_posX_SpriteMap,int initial_posY_SpriteMap,int total_rows,int total_cols,BaseGameActivity oactivity)
	{   
		// Ponemos la relacion de imagenes de la animacion en el sprite map comun
		TiledTextureRegion tTex  = TextureRegionFactory.createTiledFromAsset(game_commons.cSpriteMap , oactivity, tpath,initial_posX_SpriteMap, initial_posY_SpriteMap, total_rows, total_cols);	
		return tTex;
	}
	
	public static void loadStatusArea(Engine tEngine)
	{
		// *** INICIALIZAMOS TEXTO DE STATUS EN PANTALLA ***/
        game_commons.cStatus_FontTexture = new Texture(256, 256, TextureOptions.BILINEAR_PREMULTIPLYALPHA);
        game_commons.cStatus_t = new Font(game_commons.cStatus_FontTexture, Typeface.create(Typeface.DEFAULT, Typeface.NORMAL ), 12, true, Color.WHITE );
        tEngine.getTextureManager().loadTexture(cStatus_FontTexture);
        tEngine.getFontManager().loadFont(cStatus_t);
        
        cStatus = new ChangeableText(10, 15, cStatus_t, "",100);
	}
	
	public static TMXTiledMap loadTMX (BaseGameActivity act_temp,Engine tEngine,String tpath)
	{
		TMXTiledMap mTMXTiledMap;
        try 
        {
        		// CODI RARO NO TOCAR PER DECLARAR TMXLoader
    			final TMXLoader tmxLoader = new TMXLoader(act_temp, tEngine.getTextureManager(), TextureOptions.BILINEAR_PREMULTIPLYALPHA, new ITMXTilePropertiesListener(){public void onTMXTileWithPropertiesCreated(final TMXTiledMap pTMXTiledMap, final TMXLayer pTMXLayer, final TMXTile pTMXTile, final TMXProperties<TMXTileProperty> pTMXTileProperties){}});
    			
    			// Part de carga del mapa sprites
    			mTMXTiledMap = tmxLoader.loadFromAsset(act_temp, tpath);
    			return mTMXTiledMap;
        } 
        catch (final TMXLoadException tmxle)
        {
        	return null; 
        }
		
	}

}

