package org.anddev.andengine.engine.camera.hud.controls;

import org.anddev.andengine.engine.camera.Camera;
import org.anddev.andengine.opengl.texture.region.TextureRegion;

import android.util.FloatMath;

/**
 * TODO Test this before committing
 * TODO Think of a better name for this class
 * TODO Think if this class should be merged with the {@link AnalogOnScreenControl} or even the {@link BaseOnScreenControl} class.
 * 
 * @author AngrySpade
 * @author Nicolas Gramlich
 * @since 00:05:01 - 24.02.2011
 */
public class RadiusBoundAnalogOnScreenControl extends AnalogOnScreenControl {
	// ===========================================================
	// Constants
	// ===========================================================

	// ===========================================================
	// Fields
	// ===========================================================

	private final float mMaxDistance = 0.5f; // TODO Add parameter to constructor
	private final float mMinDistance = 0.3f; // TODO Add parameter to constructor

	// ===========================================================
	// Constructors
	// ===========================================================

	public RadiusBoundAnalogOnScreenControl(final int pX, final int pY, final Camera pCamera, final TextureRegion pControlBaseTextureRegion, final TextureRegion pControlKnobTextureRegion, final float pTimeBetweenUpdates, final IAnalogOnScreenControlListener pAnalogOnScreenControlListener) {
		super(pX, pY, pCamera, pControlBaseTextureRegion, pControlKnobTextureRegion, pTimeBetweenUpdates, pAnalogOnScreenControlListener);
	}

	public RadiusBoundAnalogOnScreenControl(final int pX, final int pY, final Camera pCamera, final TextureRegion pControlBaseTextureRegion, final TextureRegion pControlKnobTextureRegion, final float pTimeBetweenUpdates, final long pOnControlClickMaximumMilliseconds, final IAnalogOnScreenControlListener pAnalogOnScreenControlListener) {
		super(pX, pY, pCamera, pControlBaseTextureRegion, pControlKnobTextureRegion, pTimeBetweenUpdates, pOnControlClickMaximumMilliseconds, pAnalogOnScreenControlListener);
	}

	// ===========================================================
	// Getter & Setter
	// ===========================================================
	
	public float getMinDistance() {
		return this.mMinDistance;
	}

	public float getMaxDistance() {
		return this.mMaxDistance;
	}

	// ===========================================================
	// Methods for/from SuperClass/Interfaces
	// ===========================================================

	@Override
	protected void onUpdateControlKnob(float pRelativeX, float pRelativeY) {
		if((pRelativeX != 0) || (pRelativeY != 0)) {
			final float hypotenuse = FloatMath.sqrt((pRelativeX * pRelativeX) + (pRelativeY * pRelativeY));

			final float rad = (float) Math.atan2(pRelativeY, pRelativeX);
			
			if(hypotenuse > this.mMaxDistance) {
				pRelativeX = (FloatMath.cos(rad) * this.mMaxDistance) * ((pRelativeX < 0) ? -1 : 1);
				pRelativeY = (FloatMath.sin(rad) * this.mMaxDistance) * ((pRelativeY < 0) ? -1 : 1);
			} else if(hypotenuse < this.mMinDistance) {
				pRelativeX = (FloatMath.cos(rad) * this.mMinDistance) * ((pRelativeX < 0) ? -1 : 1);
				pRelativeY = (FloatMath.sin(rad) * this.mMinDistance) * ((pRelativeY < 0) ? -1 : 1);
			}
		}

		super.onUpdateControlKnob(pRelativeX, pRelativeY);
	}

	// ===========================================================
	// Methods
	// ===========================================================

	// ===========================================================
	// Inner and Anonymous Classes
	// ===========================================================
}